/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exception;

import hu.metainf.plugin.confluence.contentexporter.exception.BadRequestException;
import hu.metainf.plugin.confluence.contentexporter.exception.CexException;
import hu.metainf.plugin.confluence.contentexporter.exception.ForbiddenException;
import hu.metainf.plugin.confluence.contentexporter.exception.NotFoundException;
import hu.metainf.plugin.confluence.contentexporter.exception.NotLicensedException;
import hu.metainf.plugin.confluence.contentexporter.exception.RequiredParametersException;
import hu.metainf.plugin.confluence.contentexporter.exception.model.FieldError;
import hu.metainf.plugin.confluence.contentexporter.exception.model.ImmutableApiError;
import hu.metainf.plugin.confluence.contentexporter.exception.model.ImmutableFieldError;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.Response;

public enum ExceptionType {
    NOT_FOUND(NotFoundException.class){

        @Override
        public Response createApiError(Exception exception) {
            if (exception instanceof CexException) {
                return this.createApiError(Response.Status.NOT_FOUND, (CexException)exception);
            }
            return INTERNAL.createApiError(exception);
        }
    }
    ,
    BAD_REQUEST(BadRequestException.class){

        @Override
        public Response createApiError(Exception exception) {
            if (exception instanceof CexException) {
                return this.createApiError(Response.Status.BAD_REQUEST, (CexException)exception);
            }
            return INTERNAL.createApiError(exception);
        }
    }
    ,
    FORBIDDEN(ForbiddenException.class){

        @Override
        public Response createApiError(Exception exception) {
            if (exception instanceof CexException) {
                return this.createApiError(Response.Status.FORBIDDEN, (CexException)exception);
            }
            return INTERNAL.createApiError(exception);
        }
    }
    ,
    NOT_LICENSED(NotLicensedException.class){

        @Override
        public Response createApiError(Exception exception) {
            if (exception instanceof CexException) {
                return this.createApiError(Response.Status.FORBIDDEN, (CexException)exception);
            }
            return INTERNAL.createApiError(exception);
        }
    }
    ,
    REQUIRED_PARAMETERS(RequiredParametersException.class){

        @Override
        public Response createApiError(Exception exception) {
            if (exception instanceof RequiredParametersException) {
                ArrayList<FieldError> fieldErrors = new ArrayList<FieldError>();
                for (String requiredParameter : ((RequiredParametersException)exception).getParamNames()) {
                    fieldErrors.add((FieldError)ImmutableFieldError.builder().fieldName(requiredParameter).messageKey("cex.common.requiredParam").messageParams(Map.of("paramName", requiredParameter)).build());
                }
                return this.createApiError(Response.Status.BAD_REQUEST, exception.getMessage(), fieldErrors, new Map.Entry[0]);
            }
            return INTERNAL.createApiError(exception);
        }
    }
    ,
    VALIDATION(ConstraintViolationException.class){

        @Override
        public Response createApiError(Exception exception) {
            if (exception instanceof ConstraintViolationException) {
                ArrayList<FieldError> fieldErrors = new ArrayList<FieldError>();
                for (ConstraintViolation violation : ((ConstraintViolationException)exception).getConstraintViolations()) {
                    String path = violation.getPropertyPath().toString();
                    fieldErrors.add((FieldError)ImmutableFieldError.builder().fieldName(path).messageKey(ExceptionType.removeBracesFromMessageKey(violation.getMessageTemplate())).build());
                }
                return this.createApiError(Response.Status.BAD_REQUEST, "cex.common.error.validation", fieldErrors, new Map.Entry[0]);
            }
            return INTERNAL.createApiError(exception);
        }
    }
    ,
    INTERNAL(Exception.class){

        @Override
        public Response createApiError(Exception exception) {
            if (exception instanceof CexException) {
                Map.Entry[] args = ((CexException)exception).getArgs();
                if (args != null && Arrays.stream(args).anyMatch(e -> ((String)e.getKey()).equals("errorMessage"))) {
                    return this.createApiError(Response.Status.INTERNAL_SERVER_ERROR, exception, ((CexException)exception).getArgs());
                }
                return this.createApiError(Response.Status.INTERNAL_SERVER_ERROR, exception.getMessage(), exception);
            }
            return this.createApiError(Response.Status.INTERNAL_SERVER_ERROR, "cex.common.error", exception);
        }
    };

    private final Class<? extends Exception> exception;
    private static final Map<String, ExceptionType> BY_EXCEPTION_NAME;

    private ExceptionType(Class<? extends Exception> exception) {
        this.exception = exception;
    }

    public static ExceptionType valueOfException(Class<? extends Exception> exception) {
        ExceptionType exceptionType = BY_EXCEPTION_NAME.get(exception.getCanonicalName());
        if (exceptionType == null) {
            return INTERNAL;
        }
        return exceptionType;
    }

    public abstract Response createApiError(Exception var1);

    protected Response createApiError(Response.Status status, String messageKey, Map.Entry<String, Object> ... args) {
        return this.createApiError(status, messageKey, Collections.emptyList(), args);
    }

    protected Response createApiError(Response.Status status, String messageKey, Exception exception) {
        return this.createApiError(status, messageKey, Collections.emptyList(), Map.entry("errorMessage", exception.getMessage()), Map.entry("reason", this.getStackTraceAsString(exception)));
    }

    protected Response createApiError(Response.Status status, Exception exception, Map.Entry<String, Object> ... args) {
        return this.createApiError(status, exception.getMessage(), Collections.emptyList(), args);
    }

    protected Response createApiError(Response.Status status, CexException exception) {
        return this.createApiError(status, exception.getMessage(), Collections.emptyList(), exception.getArgs());
    }

    protected Response createApiError(Response.Status status, String messageKey, List<FieldError> fieldErrors, Map.Entry<String, Object> ... args) {
        ImmutableApiError error = ImmutableApiError.builder().status(Integer.valueOf(status.getStatusCode())).timestamp(LocalDateTime.now()).messageKey(messageKey).messageParams(this.mapEntryArrayToMap(args)).fieldErrors(fieldErrors).build();
        return Response.status((Response.Status)status).entity((Object)error).type("application/json").build();
    }

    private static String removeBracesFromMessageKey(String messageKey) {
        if (messageKey != null && messageKey.startsWith("{") && messageKey.endsWith("}")) {
            messageKey = messageKey.substring(1, messageKey.length() - 1);
        }
        return messageKey;
    }

    private Map<String, Object> mapEntryArrayToMap(Map.Entry<String, Object>[] args) {
        if (args == null || args.length == 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(args).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private String getStackTraceAsString(Throwable exception) {
        StackTraceElement[] stacktrace = exception.getStackTrace();
        if (stacktrace == null || stacktrace.length == 0) {
            return "";
        }
        return Arrays.stream(stacktrace).map(StackTraceElement::toString).collect(Collectors.joining("\n"));
    }

    static {
        BY_EXCEPTION_NAME = new HashMap<String, ExceptionType>();
        for (ExceptionType exceptionType : ExceptionType.values()) {
            BY_EXCEPTION_NAME.put(exceptionType.exception.getCanonicalName(), exceptionType);
        }
    }
}

