/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.service;

import com.atlassian.confluence.content.service.PageService;
import com.atlassian.confluence.content.service.SpaceService;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import hu.metainf.plugin.confluence.contentexporter.dao.ConfigurationRepository;
import hu.metainf.plugin.confluence.contentexporter.exception.ForbiddenException;
import hu.metainf.plugin.confluence.contentexporter.exception.NotLicensedException;
import hu.metainf.plugin.confluence.contentexporter.exporter.ExportUserInfo;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.StandalonePermissionUtil;
import hu.metainf.plugin.confluence.contentexporter.model.AddonLicense;
import hu.metainf.plugin.confluence.contentexporter.service.PermissionService;
import hu.metainf.plugin.license.LicenseInfo;
import hu.metainf.plugin.license.PluginLicenseManager;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.stereotype.Service;

@Service
public class PermissionServiceImpl
implements PermissionService {
    private final PermissionManager permissionManager;
    private final PluginLicenseManager pluginLicenseManager;
    private final SpacePermissionManager spacePermissionManager;
    private final ConfigurationRepository configurationRepository;
    private final PageService pageService;
    private final SpaceService spaceService;

    public PermissionServiceImpl(@ComponentImport PermissionManager permissionManager, PluginLicenseManager pluginLicenseManager, @ComponentImport SpacePermissionManager spacePermissionManager, ConfigurationRepository configurationRepository, @ComponentImport PageService pageService, @ComponentImport SpaceService spaceService) {
        this.permissionManager = permissionManager;
        this.pluginLicenseManager = pluginLicenseManager;
        this.spacePermissionManager = spacePermissionManager;
        this.configurationRepository = configurationRepository;
        this.pageService = pageService;
        this.spaceService = spaceService;
    }

    public void checkLicense() {
        if (!this.isLicensed()) {
            throw new NotLicensedException("cex.license.error", new Map.Entry[0]);
        }
    }

    public boolean isLicensed() {
        LicenseInfo license = this.pluginLicenseManager.getLicenseInfo();
        return license != null && license.isValid();
    }

    public void checkCurrentUserHasConfluenceAdminPermission() {
        this.checkUserId();
        if (!this.hasUserConfluenceAdminPermission()) {
            throw new ForbiddenException("cex.common.error.permission", new Map.Entry[0]);
        }
    }

    public boolean hasUserConfluenceAdminPermission() {
        this.checkUserId();
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        return this.permissionManager.isConfluenceAdministrator((User)currentUser) || this.permissionManager.isSystemAdministrator((User)currentUser);
    }

    public void checkCurrentUserHasSpaceExportPermission(Long pageId) {
        this.checkUserId();
        Page page = this.pageService.getIdPageLocator(pageId.longValue()).getPage();
        if (page == null || !this.hasUserPermissionBasedOnConfiguration(pageId)) {
            throw new ForbiddenException("cex.common.error.permission", new Map.Entry[0]);
        }
    }

    public void checkCurrentUserHasSpaceExportOrPageViewPermission(Long pageId) {
        this.checkUserId();
        if (!this.hasUserSpaceExportPermission(pageId) && !this.hasUserPageViewPermission(pageId)) {
            throw new ForbiddenException("cex.common.error.permission", new Map.Entry[0]);
        }
    }

    public boolean hasUserSpaceExportPermission(Long pageId) {
        Page page = this.pageService.getIdPageLocator(pageId.longValue()).getPage();
        return StandalonePermissionUtil.hasUserSpaceExportPermission(AuthenticatedUserThreadLocal.get(), (AbstractPage)page, this.spacePermissionManager);
    }

    public void checkCurrentUserHasSpaceAdminPermission(String spaceKey) {
        this.checkUserId();
        if (!this.hasUserSpaceAdminPermission(spaceKey)) {
            throw new ForbiddenException("cex.common.error.permission", new Map.Entry[0]);
        }
    }

    public boolean hasUserSpaceAdminPermission(String spaceKey) {
        Space space = this.spaceService.getKeySpaceLocator(spaceKey).getSpace();
        return StandalonePermissionUtil.hasUserSpaceAdminPermission(AuthenticatedUserThreadLocal.get(), space, this.spacePermissionManager);
    }

    public void checkCurrentUserHasSpaceViewPermission(String spaceKey) {
        this.checkUserId();
        if (!this.hasUserSpaceViewPermission(spaceKey)) {
            throw new ForbiddenException("cex.common.error.permission", new Map.Entry[0]);
        }
    }

    public boolean hasUserSpaceViewPermission(String spaceKey) {
        Space space = this.spaceService.getKeySpaceLocator(spaceKey).getSpace();
        return StandalonePermissionUtil.hasUserSpaceViewPermission(AuthenticatedUserThreadLocal.get(), space, this.spacePermissionManager);
    }

    public boolean hasUserPermissionBasedOnConfiguration(Long pageId) {
        Page page = this.pageService.getIdPageLocator(pageId.longValue()).getPage();
        return StandalonePermissionUtil.hasUserPermissionBasedOnConfiguration(AuthenticatedUserThreadLocal.get(), (AbstractPage)page, this.spacePermissionManager, this.configurationRepository);
    }

    public boolean hasUserPageViewPermission(Long pageId) {
        Page page = this.pageService.getIdPageLocator(pageId.longValue()).getPage();
        return StandalonePermissionUtil.canUserAccessToPage(AuthenticatedUserThreadLocal.get(), (AbstractPage)page, this.permissionManager);
    }

    public AddonLicense getAddonLicense() {
        throw new NotImplementedException();
    }

    public void validateExportUser(ExportUserInfo exportUserInfo) {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (exportUserInfo == null || currentUser == null || !Objects.equals(exportUserInfo.userId(), currentUser.getKey().getStringValue())) {
            throw new ForbiddenException("cex.common.error.permission", new Map.Entry[0]);
        }
    }

    public void checkUserId() {
        if (AuthenticatedUserThreadLocal.get() == null) {
            throw new ForbiddenException("cex.common.error.permission", new Map.Entry[0]);
        }
    }
}

