/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.newcontrollers;

import hu.metainf.plugin.confluence.contentexporter.dao.ExportProfileRepository;
import hu.metainf.plugin.confluence.contentexporter.dao.StylesheetRepository;
import hu.metainf.plugin.confluence.contentexporter.exception.BadRequestException;
import hu.metainf.plugin.confluence.contentexporter.exception.NotFoundException;
import hu.metainf.plugin.confluence.contentexporter.mapper.StylesheetMapper;
import hu.metainf.plugin.confluence.contentexporter.model.CreateStylesheetDto;
import hu.metainf.plugin.confluence.contentexporter.model.Stylesheet;
import hu.metainf.plugin.confluence.contentexporter.model.StylesheetDto;
import hu.metainf.plugin.confluence.contentexporter.model.UpdateStylesheetDto;
import hu.metainf.plugin.confluence.contentexporter.server.api.StylesheetsApi;
import hu.metainf.plugin.confluence.contentexporter.service.PermissionService;
import hu.metainf.plugin.confluence.contentexporter.util.DtoValidatorHelper;
import hu.metainf.plugin.confluence.contentexporter.util.ResponseHandler;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Path(value="/stylesheets")
public class StylesheetsController
implements StylesheetsApi {
    private final StylesheetRepository stylesheetRepository;
    private final ExportProfileRepository exportProfileRepository;
    private final PermissionService permissionService;

    @Inject
    public StylesheetsController(StylesheetRepository stylesheetRepository, ExportProfileRepository exportProfileRepository, PermissionService permissionService) {
        this.stylesheetRepository = stylesheetRepository;
        this.exportProfileRepository = exportProfileRepository;
        this.permissionService = permissionService;
    }

    @Override
    public Response stylesheetsGet() {
        List stylesheets = this.stylesheetRepository.findAll();
        List response = StylesheetMapper.INSTANCE.stylesheetListToStylesheetDtoList(stylesheets);
        return Response.ok((Object)response).build();
    }

    @Override
    public Response stylesheetsPost(CreateStylesheetDto createStylesheetDto) {
        this.permissionService.checkCurrentUserHasConfluenceAdminPermission();
        DtoValidatorHelper.validate(createStylesheetDto);
        Stylesheet stylesheet = StylesheetMapper.INSTANCE.createStylesheetDtoToStylesheet(createStylesheetDto);
        stylesheet.setId(0L);
        StylesheetDto response = StylesheetMapper.INSTANCE.stylesheetToStylesheetDto((Stylesheet)this.stylesheetRepository.save((Object)stylesheet));
        return Response.ok((Object)response).build();
    }

    @Override
    public Response stylesheetsStylesheetIdDelete(Long stylesheetId) {
        this.permissionService.checkCurrentUserHasConfluenceAdminPermission();
        Stylesheet stylesheet = (Stylesheet)this.stylesheetRepository.getById(stylesheetId.longValue());
        if (stylesheet == null) {
            throw new NotFoundException("cex.stylesheet.error.notFound", new Map.Entry[]{Map.entry("id", stylesheetId)});
        }
        this.deleteStylesheetFromExportProfiles(stylesheetId);
        this.stylesheetRepository.delete((Object)stylesheet);
        return ResponseHandler.NO_CONTENT_RESPONSE;
    }

    @Override
    public Response stylesheetsStylesheetIdGet(Long stylesheetId) {
        Stylesheet stylesheet = (Stylesheet)this.stylesheetRepository.getById(stylesheetId.longValue());
        if (stylesheet == null) {
            throw new NotFoundException("cex.stylesheet.error.notFound", new Map.Entry[]{Map.entry("id", stylesheetId)});
        }
        StylesheetDto response = StylesheetMapper.INSTANCE.stylesheetToStylesheetDto(stylesheet);
        return Response.ok((Object)response).build();
    }

    @Override
    public Response stylesheetsStylesheetIdPut(Long stylesheetId, UpdateStylesheetDto updateStylesheetDto) {
        this.permissionService.checkCurrentUserHasConfluenceAdminPermission();
        DtoValidatorHelper.validate(updateStylesheetDto);
        if (!Objects.equals(stylesheetId, updateStylesheetDto.getId())) {
            throw new BadRequestException("cex.stylesheet.error.invalid", new Map.Entry[0]);
        }
        Stylesheet stylesheet = (Stylesheet)this.stylesheetRepository.getById(stylesheetId.longValue());
        if (stylesheet == null) {
            throw new NotFoundException("cex.stylesheet.error.notFound", new Map.Entry[]{Map.entry("id", stylesheetId)});
        }
        StylesheetMapper.INSTANCE.updateStylesheetFromDto(updateStylesheetDto, stylesheet);
        StylesheetDto response = StylesheetMapper.INSTANCE.stylesheetToStylesheetDto((Stylesheet)this.stylesheetRepository.save((Object)stylesheet));
        return Response.ok((Object)response).build();
    }

    private void deleteStylesheetFromExportProfiles(long id) {
        List exportProfiles = this.exportProfileRepository.findAll();
        exportProfiles.stream().filter(profile -> profile.getFormatting().getStylesheetId() == id).forEach(profile -> {
            profile.getFormatting().setStylesheetId(0L);
            this.exportProfileRepository.save(profile);
        });
    }
}

