/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.service;

import hu.metainf.plugin.confluence.contentexporter.ContentExporterException;
import hu.metainf.plugin.confluence.contentexporter.exporter.ContentExporter;
import hu.metainf.plugin.confluence.contentexporter.service.ExportFutureTask;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProgressTrackingExecutor
extends ThreadPoolExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ProgressTrackingExecutor.class);
    private static final long ONE_DAY_IN_SEC = 86400L;
    private static final long TOO_OLD = 86400000L;
    private final Map<String, ExportFutureTask> exportMap = new ConcurrentHashMap<String, ExportFutureTask>();

    public ProgressTrackingExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public ExportFutureTask getExportFuture(String exportId) {
        ExportFutureTask exportFutureTask = this.exportMap.get(exportId);
        exportFutureTask.setLastAccessed(new Date());
        return exportFutureTask;
    }

    public ExportFutureTask execute(String exportId) throws ContentExporterException {
        if (null == exportId || !this.exportMap.containsKey(exportId)) {
            throw new ContentExporterException(String.format("Invalid or non existing export id was used to execute the export: %s", exportId));
        }
        super.execute(this.getExportFuture(exportId));
        return this.getExportFuture(exportId);
    }

    public void add(ExportFutureTask futureTask) {
        this.removeOldExports();
        this.exportMap.put(futureTask.getExportId(), futureTask);
    }

    private void removeOldExports() {
        Date now = new Date();
        logger.debug("Before removing old exports the number of export is {}", (Object)this.exportMap.size());
        for (Map.Entry<String, ExportFutureTask> entry : this.exportMap.entrySet()) {
            if (now.getTime() - entry.getValue().getLastAccessed().getTime() <= 86400000L) continue;
            logger.info("Old export with id {} removed.", (Object)entry.getKey());
            this.exportMap.remove(entry.getKey());
        }
        logger.debug("After removing old exports the number of export is {}", (Object)this.exportMap.size());
    }

    public ContentExporter getContentExporter(String exportId) {
        return this.getExportFuture(exportId).getContentExporter();
    }
}

