/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.newcontrollers;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.actions.PageAware;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.atlassian.xwork.ParameterSafe;
import hu.metainf.logger.api.Logger;
import java.io.StringWriter;
import java.io.Writer;
import javax.inject.Inject;

public class ExportContentAction
extends AbstractSpaceAction
implements PageAware {
    private final transient PageBuilderService pageBuilderService;
    private static final String OPEN_DIALOG = "open_dialog";
    private static final Logger logger = Logger.getLogger(ExportContentAction.class);
    private AbstractPage page;
    private String format;
    private long pageId;

    @Inject
    public ExportContentAction(PageBuilderService pageBuilderService) {
        this.pageBuilderService = pageBuilderService;
    }

    public String openDialog() {
        try {
            this.setPageId(this.page.getId());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return OPEN_DIALOG;
    }

    @HtmlSafe
    public String getScriptTags() {
        StringWriter writer = new StringWriter();
        WebResourceAssembler assembler = this.pageBuilderService.assembler();
        assembler.resources().requireContext("com.metainf.confluence.plugin.pagetreeexporter.pagetree-word-exporter-plugin:entrypoint-content-exporter");
        assembler.assembled().drainIncludedResources().writeHtmlTags((Writer)writer, UrlMode.ABSOLUTE);
        String result = writer.toString();
        return result.replaceAll("<script.*?baseurl-checker-resource.*?</script>", "").replaceAll("<script.*?com.atlassian.analytics.*?</script>", "");
    }

    public String getFormat() {
        return this.format;
    }

    @ParameterSafe
    public void setFormat(String format) {
        this.format = format.toUpperCase();
    }

    public long getPageId() {
        return this.pageId;
    }

    @ParameterSafe
    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    public AbstractPage getPage() {
        return this.page;
    }

    @ParameterSafe
    public void setPage(AbstractPage page) {
        this.page = page;
    }

    public boolean isPageRequired() {
        return true;
    }

    public boolean isLatestVersionRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }
}

