/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.standalone;

import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.exporter.ImageFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.io.HttpUtil;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.imageloader.ConfluenceImageFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.imageloader.ExternalHttpImageFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.imageloader.InternalHttpImageFetcher;
import java.io.InputStream;
import java.util.ArrayList;

public class StandaloneImageFetcher
implements ImageFetcher {
    private static Logger logger = Logger.getLogger(StandaloneImageFetcher.class);
    private static final String IMAGE_ATTACHMENT_PREFIX = "/download/attachments/";
    private static final String IMAGE_THUMBNAIL_PREFIX = "/download/thumbnails/";
    private static final String IMAGE_EFFECTS_PARAMETER = "&effects=";
    private String baseUrl;
    private ConfluenceImageFetcher confluenceImageFetcher;
    private ExternalHttpImageFetcher externalHttpImageFetcher;
    private InternalHttpImageFetcher internalHttpImageFetcher;

    public StandaloneImageFetcher(String baseUrl, ConfluenceImageFetcher confluenceImageFetcher, InternalHttpImageFetcher internalHttpImageFetcher) {
        this.baseUrl = baseUrl;
        this.confluenceImageFetcher = confluenceImageFetcher;
        this.externalHttpImageFetcher = new ExternalHttpImageFetcher();
        this.internalHttpImageFetcher = internalHttpImageFetcher;
    }

    public InputStream createImageInputStream(String uri, String ... params) {
        if ((uri = uri.replace("&amp;", "&")).startsWith(this.baseUrl)) {
            uri = uri.substring(this.baseUrl.length());
        }
        ArrayList<Object> imageFetchers = new ArrayList<Object>();
        if (HttpUtil.isAbsoluteUrl((String)uri)) {
            imageFetchers.add(this.externalHttpImageFetcher);
        } else if (this.isImageWithEffects(uri)) {
            imageFetchers.add(this.confluenceImageFetcher);
            imageFetchers.add(this.internalHttpImageFetcher);
        } else {
            imageFetchers.add(this.confluenceImageFetcher);
            imageFetchers.add(this.internalHttpImageFetcher);
        }
        for (ImageFetcher imageFetcher : imageFetchers) {
            InputStream is = imageFetcher.createImageInputStream(uri, new String[0]);
            logger.debug("Download image [{}] from {}: {}", new Object[]{imageFetcher.getClass().getSimpleName(), uri, is != null ? "OK" : "FAIL"});
            if (is == null) continue;
            return is;
        }
        return null;
    }

    private boolean isImageWithEffects(String uri) {
        return (uri.contains(IMAGE_ATTACHMENT_PREFIX) || uri.contains(IMAGE_THUMBNAIL_PREFIX)) && uri.contains(IMAGE_EFFECTS_PARAMETER);
    }
}

