/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.standalone.imageloader;

import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.net.ResponseException;
import hu.metainf.plugin.confluence.contentexporter.exporter.ImageFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.io.HttpUtil;
import hu.metainf.plugin.confluence.contentexporter.util.ResultHolder;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalHttpImageFetcher
implements ImageFetcher {
    private static final Logger logger = LoggerFactory.getLogger(InternalHttpImageFetcher.class);
    private final String baseUrl;
    private final String contextPath;
    private RequestFactory<?> requestFactory;

    public InternalHttpImageFetcher(String baseUrl, String contextPath) {
        this.baseUrl = baseUrl;
        this.contextPath = contextPath;
    }

    public InternalHttpImageFetcher(String baseUrl, String contextPath, RequestFactory<?> requestFactory) {
        this(baseUrl, contextPath);
        this.requestFactory = requestFactory;
    }

    public InputStream createImageInputStream(String uri, String ... params) {
        String url;
        ResultHolder result = new ResultHolder();
        String absoluteUrl = this.getAbsoluteUrl(uri);
        try {
            String decodedUrl = URLDecoder.decode(absoluteUrl, StandardCharsets.UTF_8);
            url = absoluteUrl.equals(decodedUrl) ? HttpUtil.encodeQueryParams((String)absoluteUrl) : absoluteUrl;
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            String message = String.format("Invalid url: %s", absoluteUrl);
            throw new IllegalArgumentException(message, e);
        }
        logger.debug("Internal HTTP image fetcher {} -> {}", (Object)uri, (Object)absoluteUrl);
        try {
            Request request = this.requestFactory.createRequest(Request.MethodType.GET, url);
            request.execute(response -> result.setResult((Object)response.getResponseBodyAsStream()));
        }
        catch (ResponseException | NullPointerException e) {
            String message = String.format("Can't create trusted method for %s [Internal HTTP]", uri);
            logger.error(message, e);
        }
        return (InputStream)result.getResult();
    }

    String getAbsoluteUrl(String uri) {
        if (uri.startsWith(this.contextPath)) {
            uri = uri.replace(this.contextPath, "");
        }
        return this.baseUrl + uri;
    }

    public static String getDomainName(String url) throws MalformedURLException {
        return new URL(url).getHost();
    }
}

