/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.dao.standalone;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import hu.metainf.plugin.confluence.contentexporter.dao.FontRepository;
import hu.metainf.plugin.confluence.contentexporter.dao.standalone.AbstractRepositoryImpl;
import hu.metainf.plugin.confluence.contentexporter.dao.standalone.FontDao;
import hu.metainf.plugin.confluence.contentexporter.entity.FontEntity;
import hu.metainf.plugin.confluence.contentexporter.entity.FontFileEntity;
import hu.metainf.plugin.confluence.contentexporter.model.Font;
import hu.metainf.plugin.confluence.contentexporter.model.FontFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.xerces.impl.dv.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontRepositoryImpl
extends AbstractRepositoryImpl<Font>
implements FontRepository {
    private static final Logger logger = LoggerFactory.getLogger(FontRepositoryImpl.class);
    private FontDao fontDao;

    public FontRepositoryImpl(AccessModeService accessModeService, FontDao fontDao) {
        super(accessModeService);
        this.fontDao = fontDao;
    }

    public Font getById(long id) {
        FontEntity fontEntity = (FontEntity)this.fontDao.getById(id);
        if (fontEntity == null) {
            logger.error("Font does not exist in DB (id={})", (Object)id);
            return null;
        }
        Font font = this.toModel(fontEntity);
        try {
            for (FontFileEntity fileEntity : fontEntity.getFiles()) {
                FontFile file = this.toModel(fileEntity);
                font.addFile(file);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not load file for font: %s", font.getName()), e);
        }
        return font;
    }

    private FontFile toModel(FontFileEntity fileEntity) throws IOException {
        FontFile file = new FontFile();
        file.setFileName(fileEntity.getFileName());
        if (fileEntity.getContent() == null) {
            file.setFontData(Base64.decode((String)fileEntity.getFontData()));
        } else {
            file.setFontData(IOUtils.toByteArray((InputStream)fileEntity.getContent()));
        }
        file.setHash(fileEntity.getHash());
        return file;
    }

    public List<Font> findAll() {
        List entities = this.fontDao.findAll();
        ArrayList<Font> result = new ArrayList<Font>();
        for (FontEntity entity : entities) {
            result.add(this.toModel(entity));
        }
        return result;
    }

    @Override
    public Font doSave(Font font) {
        Long id = font.getId();
        FontEntity fontEntity = id == null || id == 0L ? (FontEntity)this.fontDao.create() : (FontEntity)this.fontDao.getById(id);
        fontEntity.setName(font.getName());
        fontEntity.setCssName(font.getCssName());
        fontEntity.setFileNames(font.getFileNames());
        fontEntity.save();
        for (FontFile file : font.getFiles()) {
            FontFileEntity fileEntity = this.fontDao.createContentEntity();
            fileEntity.setFileName(file.getFileName());
            fileEntity.setFontData(Base64.encode((byte[])file.getFontData()));
            fileEntity.setFont(fontEntity);
            fileEntity.setHash(file.getHash());
            fileEntity.save();
        }
        font.setId(Long.valueOf(fontEntity.getID()));
        return font;
    }

    public void delete(Font entity) {
        FontEntity fontEntity = (FontEntity)this.fontDao.getById(entity.getId());
        for (FontFileEntity fileEntity : fontEntity.getFiles()) {
            this.fontDao.deleteContentEntity(fileEntity);
        }
        this.fontDao.delete(fontEntity);
    }

    private Font toModel(FontEntity entity) {
        Font font = null;
        if (entity != null) {
            font = new Font();
            font.setId(Long.valueOf(entity.getID()));
            font.setName(entity.getName());
            font.setCssName(entity.getCssName());
            font.setFileNames(entity.getFileNames());
        }
        return font;
    }

    public void delete(Long id) {
        FontEntity entity = (FontEntity)this.fontDao.getById(id);
        for (FontFileEntity fileEntity : entity.getFiles()) {
            this.fontDao.deleteContentEntity(fileEntity);
        }
        this.fontDao.delete(entity);
    }
}

