/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.dao.standalone;

import com.atlassian.activeobjects.tx.Transactional;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.fasterxml.jackson.databind.ObjectMapper;
import hu.metainf.plugin.confluence.contentexporter.dao.ExportProfileRepository;
import hu.metainf.plugin.confluence.contentexporter.dao.standalone.AbstractRepositoryImpl;
import hu.metainf.plugin.confluence.contentexporter.dao.standalone.ExportProfileDao;
import hu.metainf.plugin.confluence.contentexporter.entity.ExportProfileEntity;
import hu.metainf.plugin.confluence.contentexporter.model.ExportProfile;
import hu.metainf.plugin.confluence.contentexporter.model.Formatting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class ExportProfileRepositoryImpl
extends AbstractRepositoryImpl<ExportProfile>
implements ExportProfileRepository {
    private final ExportProfileDao dao;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ExportProfileRepositoryImpl(AccessModeService accessModeService, ExportProfileDao dao) {
        super(accessModeService);
        this.dao = dao;
    }

    public ExportProfile getById(long id) {
        if (id == -1L) {
            return ExportProfile.NO_PROFILE;
        }
        return this.toModel((ExportProfileEntity)this.dao.getById(id));
    }

    public List<ExportProfile> findAll() {
        List<ExportProfileEntity> entities = this.dao.findAll();
        return this.toModels(entities);
    }

    private ExportProfile toModel(ExportProfileEntity entity) {
        if (entity == null) {
            return null;
        }
        ExportProfile profile = new ExportProfile(entity.getSpace());
        profile.setId(Long.valueOf(entity.getID()));
        profile.setName(entity.getName());
        try {
            profile.setFormatting((Formatting)this.objectMapper.readValue(entity.getFormatting(), Formatting.class));
        }
        catch (IOException e) {
            String message = String.format("Could not convert profile %s to model ", entity.getName());
            throw new RuntimeException(message, e);
        }
        return profile;
    }

    @Override
    @Transactional
    public ExportProfile doSave(ExportProfile profile) {
        ExportProfileEntity entity;
        Long id = profile.getId();
        if (id == null || id == 0L) {
            entity = (ExportProfileEntity)this.dao.create();
            entity.setSpace(profile.getSpace());
        } else {
            entity = (ExportProfileEntity)this.dao.getById(id);
        }
        entity.setName(profile.getName());
        try {
            entity.setFormatting(this.objectMapper.writeValueAsString((Object)profile.getFormatting()));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save profile", e);
        }
        entity.save();
        profile.setId(Long.valueOf(entity.getID()));
        return profile;
    }

    public void delete(ExportProfile profile) {
        this.dao.delete(profile.getId());
    }

    public List<ExportProfile> findGlobals() {
        List<ExportProfileEntity> entities = this.dao.filterAndOrder("SPACE is null", "NAME", new Object[0]);
        return this.toModels(entities);
    }

    public List<ExportProfile> findAllInSpace(String spaceKey) {
        List<ExportProfileEntity> entities = this.dao.filterAndOrder("SPACE = ?", "NAME", spaceKey);
        return this.toModels(entities);
    }

    private List<ExportProfile> toModels(List<ExportProfileEntity> entities) {
        ArrayList<ExportProfile> profiles = new ArrayList<ExportProfile>();
        for (ExportProfileEntity entity : entities) {
            ExportProfile profile = this.toModel(entity);
            profiles.add(profile);
        }
        return profiles;
    }
}

