/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.controllers;

import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.atlassian.plugin.PluginParseException;
import hu.metainf.plugin.confluence.contentexporter.dao.ConfigurationRepository;
import hu.metainf.plugin.confluence.contentexporter.model.Configuration;
import java.util.Map;

public class OutputFormatCondition
extends BaseConfluenceCondition {
    public static final String PROPERTY_FORMAT = "format";
    public static final String OUTPUT_PDF = "pdf";
    public static final String OUTPUT_DOC = "doc";
    public static final String OUTPUT_HTML = "html";
    private final ConfigurationRepository configurationRepository;
    private String format;

    public OutputFormatCondition(ConfigurationRepository configurationRepository) {
        this.configurationRepository = configurationRepository;
    }

    protected boolean shouldDisplay(WebInterfaceContext webCtx) {
        Configuration configuration = this.configurationRepository.load();
        boolean result = false;
        if (OUTPUT_PDF.equals(this.format)) {
            result = configuration.isPdfExportEnabled();
        } else if (OUTPUT_DOC.equals(this.format)) {
            result = configuration.isDocExportEnabled();
        } else if (OUTPUT_HTML.equals(this.format)) {
            result = configuration.isHtmlExportEnabled();
        }
        return result;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        if (params.containsKey(PROPERTY_FORMAT)) {
            this.format = params.get(PROPERTY_FORMAT);
        }
    }
}

