/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.service;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import hu.metainf.plugin.confluence.contentexporter.ContentExporterException;
import hu.metainf.plugin.confluence.contentexporter.exporter.ContentExporter;
import hu.metainf.plugin.confluence.contentexporter.service.ExportFutureTask;
import hu.metainf.plugin.confluence.contentexporter.service.ExportRunner;
import hu.metainf.plugin.confluence.contentexporter.service.ProgressTrackingExecutor;
import org.springframework.beans.factory.DisposableBean;

public class ExportExecutorService
implements DisposableBean {
    private static final int CORE_THREAD_COUNT = 1;
    private static final int MAX_THREAD_COUNT = 2;
    private final ProgressTrackingExecutor progressTrackingExecutor;
    private TransactionTemplate transactionTemplate;

    public ExportExecutorService(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
        this.progressTrackingExecutor = new ProgressTrackingExecutor(1, 2, 30L);
    }

    public ExportFutureTask queueExport(ContentExporter contentExporter, ConfluenceUser user) {
        ExportRunner exportRunner = new ExportRunner(this.transactionTemplate, contentExporter, user);
        ExportFutureTask exportFutureTask = new ExportFutureTask(exportRunner, contentExporter.getStatus());
        this.progressTrackingExecutor.add(exportFutureTask);
        return exportFutureTask;
    }

    public ExportFutureTask execute(String exportId) throws ContentExporterException {
        return this.progressTrackingExecutor.execute(exportId);
    }

    public ExportFutureTask getExportFuture(String exportId) {
        return this.progressTrackingExecutor.getExportFuture(exportId);
    }

    public ContentExporter getContentExporter(String exportId) {
        return this.progressTrackingExecutor.getContentExporter(exportId);
    }

    public void destroy() throws Exception {
        this.progressTrackingExecutor.shutdownNow();
    }
}

