/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.service;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.exporter.ContentExporter;
import java.util.concurrent.Callable;

public class ExportRunner
implements Callable<ContentExporter> {
    private final String exportId;
    private final ContentExporter exporter;
    private final TransactionTemplate transactionTemplate;
    private final ConfluenceUser user;

    public ExportRunner(TransactionTemplate transactionTemplate, ContentExporter exporter, ConfluenceUser user) {
        this.transactionTemplate = transactionTemplate;
        this.exportId = exporter.getExportId();
        this.exporter = exporter;
        this.user = user;
    }

    @Override
    public ContentExporter call() {
        return (ContentExporter)this.transactionTemplate.execute(() -> {
            try {
                AuthenticatedUserThreadLocal.set((ConfluenceUser)this.user);
                this.exporter.export();
                return this.exporter;
            }
            catch (Throwable t) {
                Logger.getLogger(this.getClass()).error("Failed to export.", t);
                throw t;
            }
        });
    }

    public ContentExporter getExporter() {
        return this.exporter;
    }

    public String getExportId() {
        return this.exportId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExportRunner that = (ExportRunner)o;
        return this.exportId.equals(that.exportId);
    }

    public int hashCode() {
        return this.exportId.hashCode();
    }
}

