/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.dao.standalone;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.security.trust.KeyPairInitialiser;
import com.atlassian.confluence.security.trust.TrustedApplicationsManager;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.security.auth.trustedapps.CurrentApplication;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.dao.ConfigurationRepository;
import hu.metainf.plugin.confluence.contentexporter.dao.EntityPersistenceException;
import hu.metainf.plugin.confluence.contentexporter.dao.standalone.AbstractRepositoryImpl;
import hu.metainf.plugin.confluence.contentexporter.exporter.OperationResult;
import hu.metainf.plugin.confluence.contentexporter.model.Configuration;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Collections;
import java.util.List;

public class ConfigurationRepositoryImpl
extends AbstractRepositoryImpl<Configuration>
implements ConfigurationRepository {
    private static final Logger logger = Logger.getLogger(ConfigurationRepositoryImpl.class);
    private static final String PROPERTY_KEY = "Configuration";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final PluginSettingsFactory psf;
    private final TrustedApplicationsManager trustedApplicationsManager;
    private final KeyPairInitialiser keyPairInitialiser;

    public ConfigurationRepositoryImpl(PluginSettingsFactory psf, TrustedApplicationsManager trustedApplicationsManager, KeyPairInitialiser keyPairInitialiser, AccessModeService accessModeService) {
        super(accessModeService);
        this.psf = psf;
        this.trustedApplicationsManager = trustedApplicationsManager;
        this.keyPairInitialiser = keyPairInitialiser;
    }

    @Override
    public Configuration load() {
        Configuration configuration;
        PluginSettings globalSettings = this.psf.createGlobalSettings();
        Object property = globalSettings.get(PROPERTY_KEY);
        if (property != null) {
            String configurationJson = (String)property;
            try {
                configuration = (Configuration)this.objectMapper.readValue(configurationJson, Configuration.class);
            }
            catch (IOException e) {
                logger.error("Could not parse invalid configuration: {}. Returning default one.", new Object[]{configurationJson, e});
                configuration = new Configuration();
            }
        } else {
            logger.debug("No Configuration exists. Returning a default one.");
            configuration = new Configuration();
        }
        configuration.setPageBreakOptionEnabled(false);
        return configuration;
    }

    @Override
    public Configuration doSave(Configuration configuration) {
        PluginSettings globalSettings = this.psf.createGlobalSettings();
        try {
            globalSettings.put(PROPERTY_KEY, (Object)this.objectMapper.writeValueAsString((Object)configuration));
        }
        catch (JsonProcessingException e) {
            logger.error("Could not save configuration.", (Throwable)e);
            throw new EntityPersistenceException("Could not save configuration. Please refer log files.");
        }
        return configuration;
    }

    @Override
    public boolean hasConfluenceKey() {
        CurrentApplication currentApplication = this.trustedApplicationsManager.getCurrentApplication();
        return currentApplication != null;
    }

    @Override
    public OperationResult initConfluenceKey() {
        OperationResult result = new OperationResult();
        try {
            this.keyPairInitialiser.initConfluenceKey();
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            logger.error("Error initializing confluence key", (Throwable)e);
            result.addGlobalError("hu.metainf.plugin.confluence.contentexporter.error.init-confluence-key");
            result.addGlobalErrorDetails(e.getMessage());
        }
        return result;
    }

    public Configuration getById(long id) {
        return this.load();
    }

    public List<Configuration> findAll() {
        List<Configuration> result = Collections.emptyList();
        result.add(this.load());
        return result;
    }

    public void delete(Configuration entity) {
        throw new UnsupportedOperationException();
    }
}

