/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.controllers;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.plugin.osgi.bridge.external.PluginRetrievalService;
import com.atlassian.xwork.ParameterSafe;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.controllers.ActionUtil;
import hu.metainf.plugin.confluence.contentexporter.controllers.ErrorToJsonConverter;
import hu.metainf.plugin.confluence.contentexporter.controllers.MessageResolver;
import hu.metainf.plugin.confluence.contentexporter.dao.ConfigurationRepository;
import hu.metainf.plugin.confluence.contentexporter.dao.ExportProfileRepository;
import hu.metainf.plugin.confluence.contentexporter.dao.StylesheetRepository;
import hu.metainf.plugin.confluence.contentexporter.exporter.ValidationException;
import hu.metainf.plugin.confluence.contentexporter.model.ExportProfile;
import hu.metainf.plugin.confluence.contentexporter.model.Font;
import hu.metainf.plugin.confluence.contentexporter.model.PageNumbersAreaFrom;
import hu.metainf.plugin.confluence.contentexporter.model.PageNumbersAreaTo;
import hu.metainf.plugin.confluence.contentexporter.model.Stylesheet;
import hu.metainf.plugin.confluence.contentexporter.service.ExportProfileService;
import hu.metainf.plugin.confluence.contentexporter.service.FontService;
import hu.metainf.plugin.util.DataCenterHelper;
import java.io.IOException;
import java.util.List;

public class ProfileAction
extends ConfluenceActionSupport {
    private static final Logger logger = Logger.getLogger(ProfileAction.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private transient ExportProfileRepository profileRepository;
    private transient StylesheetRepository stylesheetRepository;
    private transient ExportProfileService exportProfileService;
    private transient FontService fontService;
    private transient DataCenterHelper dataCenterHelper;
    private transient ConfigurationRepository configurationRepository;
    private transient List<ExportProfile> profiles;
    private transient List<Stylesheet> stylesheets;
    private transient List<Font> fonts;
    private String profileJson;
    private long id;
    private String pluginKey;
    private boolean globalCoversSpaceMissing;
    private final transient GlobalSettingsManager globalSettingsManager;

    public ProfileAction(GlobalSettingsManager globalSettingsManager) {
        this.globalSettingsManager = globalSettingsManager;
    }

    public void setProfileRepository(ExportProfileRepository profileRepository) {
        this.profileRepository = profileRepository;
    }

    public void setStylesheetRepository(StylesheetRepository stylesheetRepository) {
        this.stylesheetRepository = stylesheetRepository;
    }

    public void setExportProfileService(ExportProfileService exportProfileService) {
        this.exportProfileService = exportProfileService;
    }

    public void setFontService(FontService fontService) {
        this.fontService = fontService;
    }

    public void setDataCenterHelper(DataCenterHelper dataCenterHelper) {
        this.dataCenterHelper = dataCenterHelper;
    }

    public void setConfigurationRepository(ConfigurationRepository configurationRepository) {
        this.configurationRepository = configurationRepository;
    }

    public String list() {
        this.globalCoversSpaceMissing = !this.exportProfileService.isGlobalCoversSpaceExists();
        this.profiles = this.profileRepository.findGlobals();
        return "success";
    }

    public String newGlobalProfile() throws IOException {
        String result = "success";
        this.loadAllStylesheetsAndFonts();
        try {
            this.profileJson = this.objectMapper.writeValueAsString((Object)new ExportProfile((String)null));
            ActionUtil.sendJsonResponse(this.profileJson);
        }
        catch (JsonProcessingException e) {
            logger.error("error creating new profile", (Throwable)e);
            result = "error";
        }
        return result;
    }

    private void loadAllStylesheetsAndFonts() {
        this.stylesheets = this.stylesheetRepository.findAll();
        this.fonts = this.fontService.loadAll();
    }

    public String dialog() {
        this.loadAllStylesheetsAndFonts();
        return "success";
    }

    public String editDialog() {
        return this.dialog();
    }

    public String load() throws IOException {
        ExportProfile profile = (ExportProfile)this.profileRepository.getById(this.id);
        String customProfileJson = this.objectMapper.writeValueAsString((Object)profile);
        ActionUtil.sendJsonResponse(customProfileJson);
        return "success";
    }

    public String save() throws IOException {
        ExportProfile profile = (ExportProfile)this.objectMapper.readValue(this.profileJson, ExportProfile.class);
        ObjectNode result = this.objectMapper.createObjectNode();
        try {
            this.exportProfileService.saveProfile(profile);
            result.put("status", "success");
        }
        catch (ValidationException e) {
            result.put("status", "invalid-data");
            result.set("errors", new ErrorToJsonConverter(new MessageResolver(this.getI18n())).toJson(e.getErrorCollection()));
        }
        ActionUtil.sendJsonResponse((JsonNode)result);
        return "none";
    }

    public String delete() throws IOException {
        this.profileRepository.delete((Object)((ExportProfile)this.profileRepository.getById(this.id)));
        ActionUtil.sendJsonResponse((JsonNode)this.objectMapper.createObjectNode());
        return "none";
    }

    public boolean isDataCenter() {
        return this.dataCenterHelper.isDataCenter();
    }

    public boolean isPageBreakOptionEnabled() {
        return this.configurationRepository.load().isPageBreakOptionEnabled();
    }

    public String getBaseUrl() {
        return this.globalSettingsManager.getGlobalSettings().getBaseUrl();
    }

    public void setPluginRetrievalService(PluginRetrievalService pluginRetrievalService) {
        this.pluginKey = pluginRetrievalService.getPlugin().getKey();
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    public String getProfileJson() {
        return this.profileJson;
    }

    @ParameterSafe
    public void setProfileJson(String profileJson) {
        this.profileJson = profileJson;
    }

    public List<ExportProfile> getProfiles() {
        return this.profiles;
    }

    public long getId() {
        return this.id;
    }

    @ParameterSafe
    public void setId(long id) {
        this.id = id;
    }

    public List<Stylesheet> getStylesheets() {
        return this.stylesheets;
    }

    public boolean isGlobalCoversSpaceMissing() {
        return this.globalCoversSpaceMissing;
    }

    public List<Font> getFonts() {
        return this.fonts;
    }

    public PageNumbersAreaTo[] getPageNumbersAreaToValues() {
        return PageNumbersAreaTo.values();
    }

    public PageNumbersAreaFrom[] getPageNumbersAreaFromValues() {
        return PageNumbersAreaFrom.values();
    }
}

