/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.controllers;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.xwork.ParameterSafe;
import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.exporter.OperationResult;
import hu.metainf.plugin.confluence.contentexporter.model.Font;
import hu.metainf.plugin.confluence.contentexporter.model.FontFile;
import hu.metainf.plugin.confluence.contentexporter.service.FontService;
import hu.metainf.plugin.confluence.contentexporter.util.ErrorCollection;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.LocalizedMessage;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.dispatcher.multipart.UploadedFile;

public class FontsAction
extends ConfluenceActionSupport {
    private static final Logger logger = Logger.getLogger(FontsAction.class);
    private static final String PARAM_FONT = "font";
    private transient FontService fontService;
    private transient List<Font> fonts = new ArrayList<Font>();
    private long id;
    private String name = "";
    private String cssName = "";
    private long attachmentMaxSize;
    private final transient GlobalSettingsManager globalSettingsManager;

    public FontsAction(GlobalSettingsManager globalSettingsManager, FontService fontService) {
        this.globalSettingsManager = globalSettingsManager;
        this.fontService = fontService;
    }

    public String loadAll() {
        this.initFields();
        return "success";
    }

    public String upload() {
        logger.debug("save called");
        try {
            MultiPartRequestWrapper multiWrapper = this.getMultiPartRequestWrapper();
            if (multiWrapper != null) {
                if (multiWrapper.hasErrors()) {
                    Collection errors = multiWrapper.getErrors();
                    for (LocalizedMessage error : errors) {
                        this.addActionError(error.toString());
                    }
                } else {
                    OperationResult saveResult;
                    String[] fileNames = multiWrapper.getFileNames(PARAM_FONT);
                    Font newFont = new Font();
                    newFont.setName(this.name);
                    newFont.setCssName(this.cssName);
                    if (fileNames != null && fileNames.length > 0) {
                        for (String fileName : fileNames) {
                            FontFile file1 = new FontFile();
                            newFont.addFile(file1);
                            file1.setFileName(fileName);
                            UploadedFile file = multiWrapper.getFiles(PARAM_FONT)[0];
                            if (file == null) continue;
                            file1.setFontData(IOUtils.toByteArray((InputStream)new FileInputStream(file.getAbsolutePath())));
                        }
                    }
                    if (!(saveResult = this.fontService.save(newFont)).isSuccess()) {
                        ErrorCollection errors = saveResult.getErrors();
                        for (Map.Entry error : errors.getErrorMessages().entrySet()) {
                            List errorArguments = errors.getErrorArguments((String)error.getKey());
                            this.addFieldError((String)error.getKey(), this.getI18n().getText((String)error.getValue()), errorArguments.toArray(new Object[errorArguments.size()]));
                        }
                        String globalErrorMessage = errors.getGlobalErrorMessage();
                        if (globalErrorMessage != null) {
                            this.addActionError(globalErrorMessage);
                        }
                    }
                }
            } else {
                this.addActionError("Could not upload font file.");
            }
        }
        catch (IOException e) {
            logger.error("Could not save file", (Throwable)e);
            this.addActionError(String.format("Could not save file. Reason: %s", e.getMessage()));
        }
        if (this.hasErrors()) {
            this.initFields();
            return "input";
        }
        return "success";
    }

    private MultiPartRequestWrapper getMultiPartRequestWrapper() {
        MultiPartRequestWrapper result = null;
        HttpServletRequest request = ServletActionContext.getRequest();
        if (request instanceof MultiPartRequestWrapper) {
            result = (MultiPartRequestWrapper)request;
        } else {
            while (request instanceof ServletRequestWrapper) {
                if (!((request = ((ServletRequestWrapper)request).getRequest()) instanceof MultiPartRequestWrapper)) continue;
                result = (MultiPartRequestWrapper)request;
                break;
            }
        }
        return result;
    }

    public String delete() {
        this.fontService.delete(this.id);
        return "success";
    }

    public long getId() {
        return this.id;
    }

    @ParameterSafe
    public void setId(long id) {
        this.id = id;
    }

    public List<Font> getFonts() {
        return this.fonts;
    }

    public String getName() {
        return this.name;
    }

    @ParameterSafe
    public void setName(String name) {
        this.name = name;
    }

    public String getCssName() {
        return this.cssName;
    }

    @ParameterSafe
    public void setCssName(String cssName) {
        this.cssName = cssName;
    }

    public long getAttachmentMaxSize() {
        return this.attachmentMaxSize;
    }

    private void initFields() {
        this.fonts = this.fontService.loadAll();
        this.attachmentMaxSize = this.globalSettingsManager.getGlobalSettings().getAttachmentMaxSize() / 1024L / 1024L;
    }
}

