/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.service;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import hu.metainf.plugin.confluence.contentexporter.dao.ConfigurationRepository;
import hu.metainf.plugin.confluence.contentexporter.exception.ForbiddenException;
import hu.metainf.plugin.confluence.contentexporter.exception.NotLicensedException;
import hu.metainf.plugin.confluence.contentexporter.exporter.ExportUserInfo;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.StandalonePermissionUtil;
import hu.metainf.plugin.confluence.contentexporter.model.AddonLicense;
import hu.metainf.plugin.confluence.contentexporter.service.PermissionService;
import hu.metainf.plugin.license.LicenseInfo;
import hu.metainf.plugin.license.PluginLicenseManager;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.stereotype.Service;

@Service
public class PermissionServiceImpl
implements PermissionService {
    private final PermissionManager permissionManager;
    private final PluginLicenseManager pluginLicenseManager;
    private final SpacePermissionManager spacePermissionManager;
    private final ConfigurationRepository configurationRepository;
    private final PageManager pageManager;

    public PermissionServiceImpl(@ComponentImport PermissionManager permissionManager, PluginLicenseManager pluginLicenseManager, @ComponentImport SpacePermissionManager spacePermissionManager, ConfigurationRepository configurationRepository, @ComponentImport PageManager pageManager) {
        this.permissionManager = permissionManager;
        this.pluginLicenseManager = pluginLicenseManager;
        this.spacePermissionManager = spacePermissionManager;
        this.configurationRepository = configurationRepository;
        this.pageManager = pageManager;
    }

    public void checkLicense() {
        if (!this.isLicensed()) {
            throw new NotLicensedException("cex.license.error", new Map.Entry[0]);
        }
    }

    public boolean isLicensed() {
        LicenseInfo license = this.pluginLicenseManager.getLicenseInfo();
        return license != null && license.isValid();
    }

    public void checkCurrentUserHasConfluenceAdminPermission() {
        if (AuthenticatedUserThreadLocal.get() == null) {
            throw new ForbiddenException("cex.common.error.permission", new Map.Entry[0]);
        }
        if (!this.hasUserConfluenceAdminPermission()) {
            throw new ForbiddenException("cex.common.error.permission", new Map.Entry[0]);
        }
    }

    public boolean hasUserConfluenceAdminPermission() {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        return this.permissionManager.isConfluenceAdministrator(currentUser) || this.permissionManager.isSystemAdministrator(currentUser);
    }

    public void checkCurrentUserHasSpaceExportPermission(Long pageId) {
        if (AuthenticatedUserThreadLocal.get() == null) {
            throw new ForbiddenException("cex.common.error.permission", new Map.Entry[0]);
        }
        Page page = this.pageManager.getPage(pageId.longValue());
        if (page == null || !StandalonePermissionUtil.hasSpaceExportPermission((User)AuthenticatedUserThreadLocal.get(), (AbstractPage)page, this.spacePermissionManager, this.configurationRepository)) {
            throw new ForbiddenException("cex.common.error.permission", new Map.Entry[0]);
        }
    }

    public boolean hasUserSpaceExportPermission(Long pageId) {
        Page page = this.pageManager.getPage(pageId.longValue());
        return StandalonePermissionUtil.hasSpaceExportPermission((User)AuthenticatedUserThreadLocal.get(), (AbstractPage)page, this.spacePermissionManager, this.configurationRepository);
    }

    public AddonLicense getAddonLicense() {
        throw new NotImplementedException();
    }

    public void validateExportUser(ExportUserInfo exportUserInfo) {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (exportUserInfo == null || currentUser == null || !Objects.equals(exportUserInfo.userId(), currentUser.getKey().getStringValue())) {
            throw new ForbiddenException("cex.common.error.permission", new Map.Entry[0]);
        }
    }
}

