/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.dao.standalone;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import hu.metainf.plugin.confluence.contentexporter.dao.EntityPersistenceException;
import hu.metainf.plugin.confluence.contentexporter.dao.Repository;

public abstract class AbstractRepositoryImpl<T>
implements Repository<T> {
    private AccessModeService accessModeService;

    protected AbstractRepositoryImpl(AccessModeService accessModeService) {
        this.accessModeService = accessModeService;
    }

    protected abstract T doSave(T var1);

    public T save(T entity) {
        this.checkReadOnlyMode(entity);
        return this.doSave(entity);
    }

    private void checkReadOnlyMode(T entity) {
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            throw new EntityPersistenceException("save operation was called on entity " + entity.getClass() + " while Read only mode was enabled!");
        }
    }
}

