/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.controllers;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.xwork.ParameterSafe;
import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.css.CssValidator;
import hu.metainf.plugin.confluence.contentexporter.dao.ExportProfileRepository;
import hu.metainf.plugin.confluence.contentexporter.dao.StylesheetRepository;
import hu.metainf.plugin.confluence.contentexporter.model.Stylesheet;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class StylesheetsAction
extends ConfluenceActionSupport {
    private static final Logger logger = Logger.getLogger(StylesheetsAction.class);
    private transient StylesheetRepository stylesheetRepository;
    private transient List<Stylesheet> stylesheets;
    private long id;
    private String name;
    private String description;
    private String css;
    private ExportProfileRepository exportProfileRepository;

    public void setStylesheetRepository(StylesheetRepository stylesheetRepository) {
        this.stylesheetRepository = stylesheetRepository;
    }

    public void setExportProfileRepository(ExportProfileRepository exportProfileRepository) {
        this.exportProfileRepository = exportProfileRepository;
    }

    public void setStylesheets(List<Stylesheet> stylesheets) {
        this.stylesheets = stylesheets;
    }

    public String loadAll() {
        this.stylesheets = this.stylesheetRepository.findAll();
        return "success";
    }

    public String create() {
        return "success";
    }

    public void validate() {
        logger.debug("validate called");
        if (StringUtils.isBlank((String)this.name)) {
            this.addFieldError("name", "Name is required!");
        }
        if (!this.isValidCss()) {
            this.addFieldError("css", "CSS is invalid!");
        }
    }

    public String save() {
        logger.debug("save called");
        if (this.hasErrors()) {
            logger.debug("save has errors");
            return "input";
        }
        Stylesheet stylesheet = new Stylesheet();
        stylesheet.setId(this.id);
        stylesheet.setName(this.name);
        stylesheet.setDescription(this.description);
        stylesheet.setCss(this.css);
        this.stylesheetRepository.save((Object)stylesheet);
        return "success";
    }

    public String load() {
        Stylesheet stylesheet = (Stylesheet)this.stylesheetRepository.getById(this.id);
        this.name = stylesheet.getName();
        this.description = stylesheet.getDescription();
        this.css = stylesheet.getCss();
        return "success";
    }

    public String delete() {
        Stylesheet stylesheet = new Stylesheet();
        stylesheet.setId(this.id);
        this.deleteStylesheetFromExportProfiles();
        this.stylesheetRepository.delete((Object)stylesheet);
        return "success";
    }

    private void deleteStylesheetFromExportProfiles() {
        List exportProfiles = this.exportProfileRepository.findAll();
        exportProfiles.stream().filter(profile -> profile.getFormatting().getStylesheetId() == this.id).forEach(profile -> {
            profile.getFormatting().setStylesheetId(0L);
            this.exportProfileRepository.save(profile);
        });
    }

    public List<Stylesheet> getStylesheets() {
        return this.stylesheets;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCss() {
        return this.css;
    }

    @ParameterSafe
    public void setId(long id) {
        this.id = id;
    }

    @ParameterSafe
    public void setName(String name) {
        this.name = name;
    }

    @ParameterSafe
    public void setDescription(String description) {
        this.description = description;
    }

    @ParameterSafe
    public void setCss(String css) {
        this.css = css;
    }

    private boolean isValidCss() {
        CssValidator cssValidator = new CssValidator();
        return cssValidator.validate(this.css);
    }
}

