/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.server.api;

import hu.metainf.plugin.confluence.contentexporter.model.ConfluencePageTreeDto;
import hu.metainf.plugin.confluence.contentexporter.model.ExportDetailsDto;
import hu.metainf.plugin.confluence.contentexporter.model.ExportParametersDto;
import hu.metainf.plugin.confluence.contentexporter.model.ExportProgressDto;
import hu.metainf.plugin.confluence.contentexporter.model.VisitedPagesDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.File;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Api(description="the export API")
public interface ExportApi {
    @GET
    @Path(value="/download")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=File.class)})
    public Response exportDownloadGet(@QueryParam(value="hash") @NotNull @ApiParam(value="ID of queued export") String var1);

    @GET
    @Path(value="/{pageId}/exportParameters")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=ExportParametersDto.class)})
    public Response exportPageIdExportParametersGet(@PathParam(value="pageId") @ApiParam(value="ID of page to export") Long var1);

    @GET
    @Path(value="/{pageId}/filter")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=VisitedPagesDto.class)})
    public Response exportPageIdFilterGet(@PathParam(value="pageId") @ApiParam(value="ID of page to export") Long var1, @QueryParam(value="labels") @NotNull @ApiParam(value="Label filters") String var2);

    @GET
    @Path(value="/{pageId}")
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=Void.class)})
    public Response exportPageIdGet(@PathParam(value="pageId") @ApiParam(value="ID of page to export") Long var1, @QueryParam(value="hash") @NotNull @ApiParam(value="ID of queued export") String var2);

    @POST
    @Path(value="/{pageId}/init")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=ExportDetailsDto.class)})
    public Response exportPageIdInitPost(@PathParam(value="pageId") @ApiParam(value="ID of page to export") Long var1, @Valid @NotNull ExportParametersDto var2);

    @GET
    @Path(value="/{pageId}/pageTree")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=ConfluencePageTreeDto.class)})
    public Response exportPageIdPageTreeGet(@PathParam(value="pageId") @ApiParam(value="ID of page to export") Long var1);

    @GET
    @Path(value="/poll")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=ExportProgressDto.class)})
    public Response exportPollGet(@QueryParam(value="hash") @NotNull @ApiParam(value="ID of current export") String var1);
}

