/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.newcontrollers;

import hu.metainf.plugin.confluence.contentexporter.exception.NotFoundException;
import hu.metainf.plugin.confluence.contentexporter.mapper.CoverPageMapper;
import hu.metainf.plugin.confluence.contentexporter.model.CoverPage;
import hu.metainf.plugin.confluence.contentexporter.model.CoverPageDto;
import hu.metainf.plugin.confluence.contentexporter.model.GlobalCoversSpaceDto;
import hu.metainf.plugin.confluence.contentexporter.server.api.CoverPageApi;
import hu.metainf.plugin.confluence.contentexporter.service.ExportProfileService;
import hu.metainf.plugin.confluence.contentexporter.util.ResponseHandler;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Path(value="/coverPage")
public class CoverPageController
implements CoverPageApi {
    private final ExportProfileService exportProfileService;

    @Inject
    public CoverPageController(ExportProfileService exportProfileService) {
        this.exportProfileService = exportProfileService;
    }

    @Override
    public Response coverPageCoverPageIdGet(Long coverPageId) {
        CoverPage coverPage = this.exportProfileService.getCoverPage(coverPageId);
        if (coverPage == null) {
            throw new NotFoundException("cex.coverPage.error.notFound", new Map.Entry[]{Map.entry("id", coverPageId)});
        }
        CoverPageDto response = CoverPageMapper.INSTANCE.coverPageToCoverPageDto(this.exportProfileService.getCoverPage(coverPageId));
        return Response.ok((Object)response).build();
    }

    @Override
    public Response coverPageGet(String term, String spaceKey) {
        List<CoverPage> coverPages = this.exportProfileService.getCoverPages(term, spaceKey);
        List response = CoverPageMapper.INSTANCE.coverPageListToCoverPageDtoList(coverPages);
        return Response.ok((Object)response).build();
    }

    @Override
    public Response coverPageGlobalCoversPageGet() {
        boolean globalCoversPageExists = this.exportProfileService.isGlobalCoversSpaceExists();
        GlobalCoversSpaceDto result = new GlobalCoversSpaceDto();
        result.setExists(Boolean.valueOf(globalCoversPageExists));
        return Response.ok((Object)result).build();
    }

    @Override
    public Response coverPagePost() {
        this.exportProfileService.createGlobalCoversSpace();
        return ResponseHandler.NO_CONTENT_RESPONSE;
    }
}

