/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.standalone;

import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.exception.CexException;
import hu.metainf.plugin.confluence.contentexporter.exporter.ResourceLoader;
import hu.metainf.plugin.confluence.contentexporter.exporter.io.IoUtil;
import hu.metainf.plugin.confluence.contentexporter.exporter.velocity.VelocityResourceLoader;
import hu.metainf.plugin.confluence.contentexporter.exporter.velocity.VelocityTemplate;
import java.io.IOException;
import java.io.InputStream;
import org.apache.velocity.app.VelocityEngine;

public class StandaloneResourceLoader
implements ResourceLoader {
    private static final Logger logger = Logger.getLogger(StandaloneResourceLoader.class);
    private final VelocityEngine velocityEngine;

    public StandaloneResourceLoader() {
        try {
            this.velocityEngine = new VelocityEngine();
            this.velocityEngine.setProperty("resource.loaders", (Object)"contentexporter");
            this.velocityEngine.setProperty("resource.loader.contentexporter.class", (Object)VelocityResourceLoader.class.getName());
            this.velocityEngine.setProperty("resource.loader.contentexporter.path", (Object)"/templates");
            this.velocityEngine.setProperty("introspector.uberspect.class", (Object)"org.apache.velocity.util.introspection.SecureUberspector");
            this.velocityEngine.setProperty("runtime.conversion.handler", (Object)"none");
            this.velocityEngine.setProperty("parser.space_gobbling", (Object)"bc");
            this.velocityEngine.setProperty("directive.if.empty_check", (Object)"false");
            logger.debug("Resource loaders for Velocity: {}", new Object[]{this.velocityEngine.getProperty("resource.loaders")});
            this.velocityEngine.init();
        }
        catch (Exception e) {
            throw new CexException("Can't initialize Velocity Engine!", (Throwable)e);
        }
    }

    public String resolveCss(String cssName) throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream is = classLoader.getResourceAsStream("templates/css/" + cssName);
        return IoUtil.read((InputStream)is);
    }

    public VelocityTemplate resolveTemplate(String templateName) throws IOException {
        try {
            return new VelocityTemplate(this.getVelocityEngine().getTemplate(templateName, "UTF-8"));
        }
        catch (Exception e) {
            throw new IOException("Can't resolve template: " + templateName, e);
        }
    }

    public InputStream resolveFont(String fontName) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResourceAsStream("fonts/" + fontName);
    }

    public InputStream resolveResource(String resourceName) {
        return this.getClass().getClassLoader().getResourceAsStream(resourceName);
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }
}

