/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.newcontrollers;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.actions.PageAware;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.atlassian.xwork.ParameterSafe;
import hu.metainf.logger.api.Logger;

public class ExportContentAction
extends AbstractSpaceAction
implements PageAware {
    @ComponentImport
    private final WebResourceManager webResourceManager;
    private static final String OPEN_DIALOG = "open_dialog";
    private static final Logger logger = Logger.getLogger(ExportContentAction.class);
    private AbstractPage page;
    private String format;
    private long pageId;

    public ExportContentAction(WebResourceManager webResourceManager) {
        this.webResourceManager = webResourceManager;
    }

    public String openDialog() throws Exception {
        try {
            this.setPageId(this.page.getId());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return OPEN_DIALOG;
    }

    @HtmlSafe
    public String getScriptTags() {
        return this.webResourceManager.getResourceTags("com.metainf.confluence.plugin.pagetreeexporter.pagetree-word-exporter-plugin:entrypoint-content-exporter", UrlMode.ABSOLUTE);
    }

    public String getFormat() {
        return this.format;
    }

    @ParameterSafe
    public void setFormat(String format) {
        this.format = format.toUpperCase();
    }

    public long getPageId() {
        return this.pageId;
    }

    @ParameterSafe
    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    public AbstractPage getPage() {
        return this.page;
    }

    @ParameterSafe
    public void setPage(AbstractPage page) {
        this.page = page;
    }

    public boolean isPageRequired() {
        return true;
    }

    public boolean isLatestVersionRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }
}

