/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.newcontrollers;

import hu.metainf.plugin.confluence.contentexporter.dao.ConfigurationRepository;
import hu.metainf.plugin.confluence.contentexporter.exception.BadRequestException;
import hu.metainf.plugin.confluence.contentexporter.exception.CexException;
import hu.metainf.plugin.confluence.contentexporter.exporter.OperationResult;
import hu.metainf.plugin.confluence.contentexporter.mapper.ConfigurationMapper;
import hu.metainf.plugin.confluence.contentexporter.model.Configuration;
import hu.metainf.plugin.confluence.contentexporter.model.ConfigurationDto;
import hu.metainf.plugin.confluence.contentexporter.server.api.ConfigurationApi;
import hu.metainf.plugin.confluence.contentexporter.service.PermissionService;
import hu.metainf.plugin.confluence.contentexporter.util.ErrorExtractor;
import hu.metainf.plugin.confluence.contentexporter.util.ResponseHandler;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Path(value="/configuration")
public class ConfigurationController
implements ConfigurationApi {
    private final ConfigurationRepository configurationRepository;
    private final PermissionService permissionService;

    public ConfigurationController(ConfigurationRepository configurationRepository, PermissionService permissionService) {
        this.configurationRepository = configurationRepository;
        this.permissionService = permissionService;
    }

    @Override
    public Response configurationConfluenceKeyGet() {
        this.permissionService.checkCurrentUserHasConfluenceAdminPermission();
        OperationResult result = this.configurationRepository.initConfluenceKey();
        ErrorExtractor.throwExceptionIfOperationResultHasErrors(result, (CexException)new BadRequestException("cex.configuration.error.confluenceKey", new Map.Entry[0]));
        return ResponseHandler.NO_CONTENT_RESPONSE;
    }

    @Override
    public Response configurationGet() {
        ConfigurationDto response = ConfigurationMapper.INSTANCE.configurationToConfigurationDto(this.configurationRepository.load());
        response.setConfluenceKeyMissing(Boolean.valueOf(!this.configurationRepository.hasConfluenceKey()));
        return Response.ok((Object)response).build();
    }

    @Override
    public Response configurationPut(ConfigurationDto configurationDto) {
        this.permissionService.checkCurrentUserHasConfluenceAdminPermission();
        Configuration configuration = ConfigurationMapper.INSTANCE.configurationDtoToConfiguration(configurationDto);
        ConfigurationDto response = ConfigurationMapper.INSTANCE.configurationToConfigurationDto((Configuration)this.configurationRepository.save(configuration));
        response.setConfluenceKeyMissing(Boolean.valueOf(!this.configurationRepository.hasConfluenceKey()));
        return Response.ok((Object)response).build();
    }
}

