/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.controllers;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.xwork.ParameterSafe;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import hu.metainf.plugin.confluence.contentexporter.controllers.ActionUtil;
import hu.metainf.plugin.confluence.contentexporter.controllers.ErrorToJsonConverter;
import hu.metainf.plugin.confluence.contentexporter.controllers.MessageResolver;
import hu.metainf.plugin.confluence.contentexporter.dao.ConfigurationRepository;
import hu.metainf.plugin.confluence.contentexporter.exporter.OperationResult;
import hu.metainf.plugin.confluence.contentexporter.model.Configuration;
import hu.metainf.plugin.util.DataCenterHelper;
import java.io.IOException;

public class ConfigurationAction
extends ConfluenceActionSupport {
    private transient ConfigurationRepository configurationRepository;
    private transient DataCenterHelper dataCenterHelper;
    private boolean pdfExportEnabled;
    private boolean docExportEnabled;
    private boolean htmlExportEnabled;
    private boolean pageBreakOptionEnabled;
    private String exportPermission;
    private String exportPageSelection;
    private boolean confluenceKeyMissing;

    public void setConfigurationRepository(ConfigurationRepository configurationRepository) {
        this.configurationRepository = configurationRepository;
    }

    public void setDataCenterHelper(DataCenterHelper dataCenterHelper) {
        this.dataCenterHelper = dataCenterHelper;
    }

    public String load() throws IOException {
        Configuration configuration = this.configurationRepository.load();
        this.pdfExportEnabled = configuration.isPdfExportEnabled();
        this.docExportEnabled = configuration.isDocExportEnabled();
        this.htmlExportEnabled = configuration.isHtmlExportEnabled();
        this.setPageBreakOptionEnabled(configuration.isPageBreakOptionEnabled());
        this.exportPermission = configuration.getExportPermission();
        this.exportPageSelection = configuration.getExportPageSelection();
        this.confluenceKeyMissing = !this.configurationRepository.hasConfluenceKey();
        return "success";
    }

    public String initConfluenceKey() throws IOException {
        OperationResult operationResult = this.configurationRepository.initConfluenceKey();
        ObjectNode jsonNode = new ErrorToJsonConverter(new MessageResolver(this.getI18n())).operationResultToJson(operationResult);
        ActionUtil.sendJsonResponse((JsonNode)jsonNode);
        return "none";
    }

    public String save() throws IOException {
        Configuration configuration = new Configuration(this.pdfExportEnabled, this.docExportEnabled, this.htmlExportEnabled, this.pageBreakOptionEnabled, this.exportPermission, this.exportPageSelection);
        this.configurationRepository.save(configuration);
        return "success";
    }

    public boolean isDataCenter() {
        return this.dataCenterHelper.isDataCenter();
    }

    public boolean isPageBreakOptionEnabled() {
        return this.isDataCenter() ? false : this.pageBreakOptionEnabled;
    }

    @ParameterSafe
    public void setPageBreakOptionEnabled(boolean pageBreakOptionEnabled) {
        this.pageBreakOptionEnabled = this.isDataCenter() ? false : pageBreakOptionEnabled;
    }

    public boolean isPdfExportEnabled() {
        return this.pdfExportEnabled;
    }

    @ParameterSafe
    public void setPdfExportEnabled(boolean pdfExportEnabled) {
        this.pdfExportEnabled = pdfExportEnabled;
    }

    public boolean isDocExportEnabled() {
        return this.docExportEnabled;
    }

    @ParameterSafe
    public void setDocExportEnabled(boolean docExportEnabled) {
        this.docExportEnabled = docExportEnabled;
    }

    public boolean isHtmlExportEnabled() {
        return this.htmlExportEnabled;
    }

    @ParameterSafe
    public void setHtmlExportEnabled(boolean htmlExportEnabled) {
        this.htmlExportEnabled = htmlExportEnabled;
    }

    public boolean isConfluenceKeyMissing() {
        return this.confluenceKeyMissing;
    }

    public String getExportPermission() {
        return this.exportPermission;
    }

    @ParameterSafe
    public void setExportPermission(String exportPermission) {
        this.exportPermission = exportPermission;
    }

    public String getExportPageSelection() {
        return this.exportPageSelection;
    }

    @ParameterSafe
    public void setExportPageSelection(String exportPageSelection) {
        this.exportPageSelection = exportPageSelection;
    }
}

