/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.service;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.contentnames.Category;
import com.atlassian.confluence.search.contentnames.ContentNameSearcher;
import com.atlassian.confluence.search.contentnames.QueryTokenizer;
import com.atlassian.confluence.search.contentnames.ResultTemplate;
import com.atlassian.confluence.search.contentnames.SearchResult;
import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.dao.ExportProfileRepository;
import hu.metainf.plugin.confluence.contentexporter.exporter.ValidationException;
import hu.metainf.plugin.confluence.contentexporter.model.CoverPage;
import hu.metainf.plugin.confluence.contentexporter.model.ExportProfile;
import hu.metainf.plugin.confluence.contentexporter.service.ConfluenceContentService;
import hu.metainf.plugin.confluence.contentexporter.service.ExportProfileService;
import hu.metainf.plugin.confluence.contentexporter.util.ErrorCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class ExportProfileServiceImpl
implements ExportProfileService {
    private static final Logger logger = Logger.getLogger(ExportProfileServiceImpl.class);
    private static final String GLOBAL_EXPORT_COVERS_KEY = "CEXCOVERS";
    private static final String GLOBAL_EXPORT_COVERS_NAME = "Content Exporter global cover pages";
    private static final String GLOBAL_EXPORT_COVERS_DESC = "This space holds global cover pages for the Content Exporter addon";
    private final ExportProfileRepository profileRepository;
    private final ConfluenceContentService confluenceContentService;
    private final ContentNameSearcher nameSearcher;
    private final QueryTokenizer contentNameQueryTokenizer;
    private final PageManager pageManager;

    public ExportProfileServiceImpl(ExportProfileRepository profileRepository, ConfluenceContentService confluenceContentService, ContentNameSearcher nameSearcher, QueryTokenizer contentNameQueryTokenizer, PageManager pageManager) {
        this.profileRepository = profileRepository;
        this.confluenceContentService = confluenceContentService;
        this.nameSearcher = nameSearcher;
        this.contentNameQueryTokenizer = contentNameQueryTokenizer;
        this.pageManager = pageManager;
    }

    @Override
    public ExportProfile saveProfile(ExportProfile profile) {
        if (profile.getName() == null || "".equals(profile.getName())) {
            logger.error("Missing Export Profile name");
            ErrorCollection errorCollection = new ErrorCollection();
            errorCollection.addErrorMessage("name", "hu.metainf.plugin.confluence.contentexporter.mandatory");
            throw new ValidationException(errorCollection);
        }
        return (ExportProfile)this.profileRepository.save((Object)profile);
    }

    @Override
    public boolean isGlobalCoversSpaceExists() {
        return this.confluenceContentService.isSpaceExists(GLOBAL_EXPORT_COVERS_KEY);
    }

    @Override
    public CoverPage getCoverPage(Long id) {
        Page page;
        CoverPage result = null;
        if (null != id && null != (page = this.pageManager.getPage(id.longValue()))) {
            result = new CoverPage(Long.valueOf(page.getId()), page.getTitle());
            result.setGlobal(GLOBAL_EXPORT_COVERS_KEY.equals(page.getSpaceKey()));
        }
        return result;
    }

    @Override
    public void createGlobalCoversSpace() {
        this.confluenceContentService.createSpace(GLOBAL_EXPORT_COVERS_KEY, GLOBAL_EXPORT_COVERS_NAME, GLOBAL_EXPORT_COVERS_DESC, this);
    }

    @Override
    public List<CoverPage> getCoverPages(String title, String spaceKey) {
        List tokens = this.contentNameQueryTokenizer.tokenize(title);
        if (tokens.isEmpty()) {
            return Collections.emptyList();
        }
        String[] keys = spaceKey != null ? new String[]{spaceKey, GLOBAL_EXPORT_COVERS_KEY} : new String[]{GLOBAL_EXPORT_COVERS_KEY};
        ResultTemplate resultTemplate = new ResultTemplate();
        resultTemplate.addCategory(Category.PAGES, 10);
        Map categoryListMap = this.nameSearcher.search(tokens, resultTemplate, keys);
        List pageResults = (List)categoryListMap.get(Category.PAGES);
        ArrayList<CoverPage> coverPages = new ArrayList<CoverPage>(pageResults.size());
        for (SearchResult result : pageResults) {
            CoverPage page = new CoverPage(result.getId(), result.getName());
            page.setGlobal(GLOBAL_EXPORT_COVERS_KEY.equals(result.getSpaceKey()));
            coverPages.add(page);
        }
        Collections.sort(coverPages, new Comparator<CoverPage>(){

            @Override
            public int compare(CoverPage o1, CoverPage o2) {
                int result = o1.isGlobal() ? (o2.isGlobal() ? 0 : 1) : (o2.isGlobal() ? -1 : 0);
                return result;
            }
        });
        return coverPages;
    }
}

