/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.standalone.imageloader;

import com.atlassian.confluence.importexport.resource.DownloadResourceManager;
import com.atlassian.confluence.importexport.resource.DownloadResourceNotFoundException;
import com.atlassian.confluence.importexport.resource.DownloadResourceReader;
import com.atlassian.confluence.importexport.resource.UnauthorizedDownloadResourceException;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.renderer.util.UrlUtil;
import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.exporter.ImageFetcher;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.net.URLCodec;

public class ConfluenceImageFetcher
implements ImageFetcher {
    private static final Logger logger = Logger.getLogger(ConfluenceImageFetcher.class);
    private static final String DATA_PREFIX = "data:";
    private static final String FILE_PREFIX = "file:";
    private static final Pattern RESOURCE_PATH_PATTERN = Pattern.compile("/s/(.*)/_/");
    private final PluginResourceLocator pluginResourceLocator;
    private final DownloadResourceManager downloadResourceManager;

    public ConfluenceImageFetcher(PluginResourceLocator pluginResourceLocator, DownloadResourceManager downloadResourceManager) {
        this.pluginResourceLocator = pluginResourceLocator;
        this.downloadResourceManager = downloadResourceManager;
    }

    public InputStream createImageInputStream(String uri) {
        String relativeUri = uri;
        if (relativeUri.startsWith(FILE_PREFIX)) {
            relativeUri = relativeUri.substring(FILE_PREFIX.length());
        }
        Matcher matcher = RESOURCE_PATH_PATTERN.matcher(relativeUri);
        String decodedUri = relativeUri = matcher.replaceFirst("/");
        try {
            decodedUri = URLDecoder.decode(relativeUri, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Can't decode uri: {}", new Object[]{uri, e});
        }
        if (this.pluginResourceLocator.matches(decodedUri)) {
            Map queryParams = UrlUtil.getQueryParameters((String)decodedUri);
            decodedUri = this.stripQueryString(decodedUri);
            logger.debug("Downloading image via plugin resource locator uri: {}", new Object[]{decodedUri});
            DownloadableResource resource = this.pluginResourceLocator.getDownloadableResource(decodedUri, queryParams);
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                resource.streamResource((OutputStream)outputStream);
                return new ByteArrayInputStream(outputStream.toByteArray());
            }
            catch (DownloadException e) {
                logger.warn("Can't create image input stream for {} [Plugin locator]: {}", new Object[]{decodedUri, e.getMessage()});
            }
        } else if (this.downloadResourceManager.matches(decodedUri)) {
            String userName = AuthenticatedUserThreadLocal.getUsername();
            DownloadResourceReader downloadResourceReader = null;
            String strippedUri = this.stripQueryString(decodedUri);
            logger.debug("Downloading image via download resource manager uri: {}", new Object[]{strippedUri});
            downloadResourceReader = this.getResourceReader(decodedUri, userName, strippedUri);
            if (downloadResourceReader == null) {
                strippedUri = this.stripQueryString(relativeUri);
                downloadResourceReader = this.getResourceReader(relativeUri, userName, strippedUri);
            }
            if (downloadResourceReader != null) {
                try {
                    return downloadResourceReader.getStreamForReading();
                }
                catch (Exception e) {
                    logger.warn("Can't create image input stream for {} [Download manager]: {}", new Object[]{decodedUri, e.getMessage()});
                }
            }
        } else if (uri.startsWith(DATA_PREFIX)) {
            return this.streamDataUrl(uri);
        }
        return null;
    }

    private String stripQueryString(String uri) {
        int queryIndex = uri.indexOf(63);
        if (queryIndex > 0) {
            uri = uri.substring(0, queryIndex);
        }
        return uri;
    }

    private DownloadResourceReader getResourceReader(String uri, String userName, String strippedUri) {
        DownloadResourceReader downloadResourceReader = null;
        try {
            Map params = UrlUtil.getQueryParameters((String)uri);
            downloadResourceReader = this.downloadResourceManager.getResourceReader(userName, strippedUri, params);
            logger.debug("Downloading image via download resource manager uri: {}, stripped uri: {}, params: {}, downloader class: {}", new Object[]{uri, strippedUri, params.toString(), downloadResourceReader.getClass().getName()});
        }
        catch (UnauthorizedDownloadResourceException e) {
            logger.warn("Not authorized to download resource {}, reason: {}", new Object[]{uri, e.getMessage()});
        }
        catch (DownloadResourceNotFoundException e) {
            logger.warn("Resource not found for {}, reason: {}", new Object[]{uri, e.getMessage()});
        }
        return downloadResourceReader;
    }

    private InputStream streamDataUrl(String dataUrl) {
        byte[] bytes;
        int dataIndex = dataUrl.indexOf(44);
        String data = dataUrl.substring(dataIndex + 1);
        if (dataUrl.substring(0, dataIndex).endsWith(";base64")) {
            bytes = Base64.decodeBase64((String)data);
        } else {
            try {
                bytes = URLCodec.decodeUrl((byte[])StringUtils.getBytesUsAscii((String)data));
            }
            catch (DecoderException e) {
                throw new IllegalArgumentException("Invalid data URL: \"" + dataUrl + "\".", e);
            }
        }
        return new ByteArrayInputStream(bytes);
    }
}

