/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.dao.standalone;

import com.atlassian.activeobjects.tx.Transactional;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.dao.ExportParametersRepository;
import hu.metainf.plugin.confluence.contentexporter.dao.standalone.AbstractRepositoryImpl;
import hu.metainf.plugin.confluence.contentexporter.dao.standalone.ContentExportDao;
import hu.metainf.plugin.confluence.contentexporter.entity.ContentExportEntity;
import hu.metainf.plugin.confluence.contentexporter.model.ExportParameters;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;

public class ExportParametersRepositoryImpl
extends AbstractRepositoryImpl<ExportParameters>
implements ExportParametersRepository {
    private static final Logger logger = Logger.getLogger(ExportParametersRepositoryImpl.class);
    private ContentExportDao contentExportDao;
    private final ObjectMapper om = new ObjectMapper();

    public ExportParametersRepositoryImpl(ContentExportDao contentExportDao) {
        this.contentExportDao = contentExportDao;
    }

    @Override
    @Transactional
    public ExportParameters doSave(ExportParameters exportParameters) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        String userKey = confluenceUser != null ? confluenceUser.getKey().getStringValue() : null;
        ContentExportEntity contentExportEntity = (ContentExportEntity)this.contentExportDao.first("CONTENT_ID = ? AND USER_KEY = ?", "ID DESC", exportParameters.getRootContentId(), userKey);
        if (contentExportEntity == null) {
            contentExportEntity = (ContentExportEntity)this.contentExportDao.create();
        }
        contentExportEntity.setContentId(exportParameters.getRootContentId());
        contentExportEntity.setName("LAST");
        contentExportEntity.setUserKey(userKey);
        contentExportEntity.setExportTime(new Date());
        try {
            contentExportEntity.setExportParameters(new ObjectMapper().writeValueAsString((Object)exportParameters));
        }
        catch (JsonProcessingException e) {
            logger.error("could not parse export parameters: {}", new Object[]{exportParameters, e});
        }
        this.contentExportDao.update(contentExportEntity);
        return exportParameters;
    }

    public ExportParameters getById(long id) {
        throw new NotImplementedException("not yet implemented");
    }

    public List<ExportParameters> findAll() {
        throw new NotImplementedException("not yet implemented");
    }

    public void delete(ExportParameters entity) {
        throw new NotImplementedException("not yet implemented");
    }

    @Override
    public ExportParameters loadLastExportParameters(long pageId) {
        ContentExportEntity lastExport = this.contentExportDao.last(pageId, AuthenticatedUserThreadLocal.get().getKey().getStringValue());
        if (lastExport == null) {
            return null;
        }
        try {
            return (ExportParameters)this.om.readValue(lastExport.getExportParameters(), ExportParameters.class);
        }
        catch (IOException e) {
            logger.error("Could not parse export parameters: {}", new Object[]{lastExport.getExportParameters(), e});
            return null;
        }
    }
}

