/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.dao.standalone;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.tx.Transactional;
import com.atlassian.sal.api.transaction.TransactionCallback;
import hu.metainf.plugin.confluence.contentexporter.dao.EntityPersistenceException;
import hu.metainf.plugin.util.AccessModeService;
import java.util.Arrays;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Entity;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public abstract class AbstractDao<T extends Entity> {
    private AccessModeService accessModeService = new AccessModeService();
    protected ActiveObjects ao;

    public AbstractDao(ActiveObjects ao) {
        this.ao = ao;
    }

    private void checkReadOnlyMode() {
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            throw new EntityPersistenceException("Create, delete or update operation was called in AO while Read only mode was enabled!");
        }
    }

    public T first(String where, String orderBy, Object ... params) {
        List<T> hits = this.filterAndOrder(where, orderBy, params);
        return (T)(hits != null && hits.size() > 0 ? (Entity)hits.get(0) : null);
    }

    public List<T> filter(String where, Object ... params) {
        return Arrays.asList((Entity[])this.ao.find(this.getPersistentClass(), Query.select().where(where, params)));
    }

    public List<T> filterAndOrder(String where, String orderBy, Object ... params) {
        return Arrays.asList((Entity[])this.ao.find(this.getPersistentClass(), Query.select().where(where, params).order(orderBy)));
    }

    public T create() {
        this.checkReadOnlyMode();
        return (T)((Entity)this.ao.create(this.getPersistentClass(), new DBParam[0]));
    }

    public T getById(Long id) {
        if (id == null) {
            return null;
        }
        Entity[] hits = (Entity[])this.ao.find(this.getPersistentClass(), Query.select().where("ID = ?", new Object[]{id}));
        return (T)(hits == null || hits.length == 0 ? null : hits[0]);
    }

    public void delete(Long id) {
        this.checkReadOnlyMode();
        this.delete(this.getById(id));
    }

    public void delete(T entity) {
        if (entity != null) {
            this.checkReadOnlyMode();
            this.ao.delete(new RawEntity[]{entity});
        }
    }

    public List<T> findAll() {
        return Arrays.asList((Entity[])this.ao.find(this.getPersistentClass()));
    }

    public void delete(final String where, final Object ... params) {
        this.checkReadOnlyMode();
        this.ao.executeInTransaction(new TransactionCallback<T>(){

            public T doInTransaction() {
                Entity[] hits = (Entity[])AbstractDao.this.ao.find(AbstractDao.this.getPersistentClass(), Query.select().where(where, params));
                AbstractDao.this.ao.delete((RawEntity[])hits);
                return null;
            }
        });
    }

    @Transactional
    public void update(T entity) {
        this.checkReadOnlyMode();
        entity.save();
    }

    protected abstract Class<T> getPersistentClass();
}

