$(function() {
    AJS.CONTENT_EXPORTER = {
        init: function(options) {
            this.options = options;
            this.exportDialogTemplate = AJS.$("#cex-export-dialog-template").remove();
            this.exportProgressDialogTemplate = AJS.$("#content-exporter-progress-dialog").remove();
            this.outputFormats = new Map();
            this.outputFormats.set("PDF", "PDF");
            this.outputFormats.set("DOC", "Word");
            this.outputFormats.set("HTML", "HTML");

            this.createExportDialog();
            this.createExportProgressDialog();
            this.exportDialog.show();

            if (!this.options.licensed) {
                this.showError("Sorry, Content Exporter's license is unavailable or expired, export is not allowed!<br/>"
                        + "<a href=" + this.options.urls.upmUrl + " target='_blank'>Click here</a>"
                        + " to manage the add-on's license in Confluence's Plugin Manager.");
            }
        },

        createExportProgressDialog: function() {
            if (this.exportProgressDialog) {
                return;
            }

            this.exportProgressDialog = new AJS.Dialog({
                width: 500,
                height: 220,
                id: "cex-export-progress-dialog",
                closeOnOutsideClick: false,
                keypressListener: $.proxy(function(e) {
                    if (e.keyCode == 27) {
                        this.closeAll(this)
                    }
                }, this)
            });

            this.exportProgressDialog.addHeader("Export in progress");
            AJS.$("#cex-export-progress-dialog .dialog-title").prepend(this.headerAvatarTemplate.clone());

            this.exportProgressDialog.addLink("Cancel", $.proxy(function(dialog) {
                this.closeAll(dialog);
            }, this), "#");

            this.exportProgressDialog.addPanel("", this.exportProgressDialogTemplate.clone(), "panel-body");
        },

        createExportDialog: function() {
            this.exportDialog = new AJS.Dialog({
                width: Math.min(this.options.width, 1300),
                height: Math.min(this.options.height, 700),
                id: "cex-export-dialog",
                closeOnOutsideClick: false,
                keypressListener: $.proxy(function(e) {
                    if (e.keyCode == 27) {
                        this.closeAll(this)
                    }
                }, this)
            });

            this.exportDialog.addButton("Export", $.proxy(function(dialog) {
                var exportParameters = AJS.CONTENT_EXPORTER.exportParameters;
                exportParameters.exportContentType = AJS.$("#export-type-select").val();
                exportParameters.labels = AJS.$("#label-filter-input").val();
                exportParameters.content = this.exportDialogNode.find("#tree-container input.checkbox:checked").map(function() {
                    return AJS.$(this).data("page-id");
                }).get();
                var data = [{"name": "pageId", "value": AJS.$("#content-exporter-page-id").val()},
                    {"name":"exportParametersJson",
                        "value":JSON.stringify(exportParameters)}];
                this.initExport(data);
            }, this), "content-exporter-export-button");

            this.exportDialog.addLink("Cancel", $.proxy(function(dialog) {
                this.closeAll(dialog);
            }, this), "#");

            this.exportDialog.addPanel("", this.exportDialogTemplate.clone(), "panel-body");

            this.exportDialogNode = AJS.$("#" + this.exportDialog.id);

            this.exportParameters = JSON.parse(this.exportDialogNode.find("#export-parameters").val());

            this.exportDialog.addHeader("Export to " + this.outputFormats.get(this.exportParameters.format));

            this.exportDialogNode.find(".dialog-title").prepend(this.headerAvatarTemplate.clone());

            this.exportDialogNode.find("#export-type-select").change($.proxy(function(e) {
                this.exportParameters.exportContentType = AJS.$(e.target).val();
                this.updateContentSelector();
            }, this));

            this.exportDialogNode.find("#export-type-select, #tree-container input.checkbox").change($.proxy(function(e) {
                this.updateExportButton();
            }, this));

            //tick / untick subtree
            this.exportDialogNode.find("#tree-container input.checkbox").click($.proxy(function(e) {
                var checkbox = AJS.$(e.target);
                var pageId = checkbox.attr("data-page-id");
                var checked = checkbox.attr("checked");
                this.exportDialogNode.find("#container" + pageId + " input[type=checkbox]").attr("checked", checked ? true : false);
                this.updateExportButton();
            }, this));

            //apply label filter
            this.exportDialogNode.find("#label-filter-input").keypress($.proxy(function(e) {
                if (e.keyCode == 13) {
                    this.applyLabelFilter();
                    e.preventDefault();
                }
            }, this));

            //apply label filter
            this.exportDialogNode.find("#apply-label-filter-button").click($.proxy(function(e) {
                this.applyLabelFilter();
                e.preventDefault();
            }, this));

            //clear label filter
            this.exportDialogNode.find("#clear-label-filter-button").click($.proxy(function(e) {
                var filterLabel = this.exportDialogNode.find("#label-filter-input");
                var treeContainer = this.exportDialogNode.find("#tree-container");
                filterLabel.val("");
                treeContainer.find("input[type=checkbox]").prop("checked", true);
                this.updateExportButton();
                e.preventDefault();
            }, this));

            this.exportDialogNode.find(".cex-page-tree .toggle-all").on('click', function (e) {
                const buttonIcon = AJS.$(this).children('i');
                const allChildren = AJS.$('.cex-page-tree').find('.content-tree-node-children');
                const parentIcons = allChildren.parent('li.parent_li').find(' > span > i');
                if (buttonIcon.hasClass('fa-caret-up')) {
                    allChildren.hide('fast');
                    parentIcons.removeClass('fa-minus-square').addClass('fa-plus-square');
                    buttonIcon.removeClass('fa-caret-up').addClass('fa-caret-down');
                    AJS.$(this).attr('title', 'Expand all');
                }
                else {
                    allChildren.show('fast');
                    parentIcons.removeClass('fa-plus-square').addClass('fa-minus-square');
                    buttonIcon.removeClass('fa-caret-down').addClass('fa-caret-up');
                    AJS.$(this).attr('title', 'Collapse all');
                }
                e.preventDefault();
            });

            this.exportDialogNode.find('.cex-page-tree li.parent_li > span').on('click', function (e) {
                if(e.target.type === undefined) {
                    const children = AJS.$(this).parent('li.parent_li').children('.content-tree-node-children');
                    const childrenIcons = AJS.$(this).find(' > i');
                    if (children.is(":visible")) {
                        children.hide('fast');
                        childrenIcons.removeClass('fa-minus-square').addClass('fa-plus-square');
                    } else {
                        children.show('fast');
                        childrenIcons.removeClass('fa-plus-square').addClass('fa-minus-square');
                    }
                    e.stopPropagation();
                }
            });

            this.exportDialogNode.find("#profile-customize").click($.proxy(function(e){
                e.preventDefault();

                this.disabledControls = MIJS.disableControls(this.exportDialogNode.find("button"));
                this.spinner = MIJS.startSpin(this.exportDialogNode);

                var profileId = this.exportParameters.profileId;
                var profileExists = this.exportDialogNode.find("#profile option[value='"+profileId+"']").length > 0;
                if(profileId && profileExists){
                    this.customizeProfile(profileId);
                }
                else {
                    this.editCustomProfile();
                }
            }, this));

            this.exportDialogNode.find("#profile").change($.proxy(function(e){
                this.exportParameters.profileId = AJS.$(e.currentTarget).val();
                this.updateProfileSelector();
            },this));
            AJS.$("#export-type-select").val(this.exportParameters.exportContentType);

            this.updateContentSelector();
            this.updateProfileSelector();
            this.updateExportButton();
        },

        customizeProfile: function(profileId) {
            AJS.log("customize profile(id: " + profileId + ")");
            var self = this;
            AJS.$.ajax({
                url: this.options.urls.loadProfile + "?id=" + profileId,
                type: "GET",
                data: this.options.params,
                cache: false,
                dataType: "json",
                success: function(profile) {
                    profile.id = null;
                    AJS.$.ajax({
                        url: self.options.urls.profileDialog,
                        type: "GET",
                        data: self.options.params,
                        cache: false,
                        dataType: "html",
                        success: function(exportProfileDialog) {
                            AJS.log("customize profile success");
                            var container = AJS.$("#content-exporter-profile-container");
                            if (container.length > 0) {
                                container.empty();
                            }
                            else {
                                container = AJS.$("<div id='content-exporter-profile-container' style='display: none'></div>");
                                AJS.$("body").append(container);
                            }
                            container.append(exportProfileDialog);
                            self.initCustomizeProfileDialog(profile);
                        },
                        error: function() {
                            alert("Can not initialize Content Exporter!");
                        }
                    }).always(function() {
                        MIJS.enableControls(self.disabledControls);
                        MIJS.stopSpin(self.spinner);
                    });
                },
                error: function() {
                    MIJS.enableControls(self.disabledControls);
                    MIJS.stopSpin(self.spinner);
                    alert("Can not initialize Content Exporter!");
                }
            });
        },

        editCustomProfile: function() {
            AJS.log("customize profile(name: " + this.exportParameters.customProfileName + ")");
            var self = this;
            AJS.$.ajax({
                url: this.options.urls.profileDialog,
                type: "GET",
                data: this.options.params,
                cache: false,
                dataType: "html",
                success: function(exportProfileDialog) {
                    AJS.log("customize profile success");
                    var container = AJS.$("#content-exporter-profile-container");
                    if (container.length > 0) {
                        container.empty();
                    }
                    else {
                        container = AJS.$("<div id='content-exporter-profile-container' style='display: none'></div>");
                        AJS.$("body").append(container);
                    }
                    container.append(exportProfileDialog);
                    var exportParameters = self.exportParameters;
                    var customProfile = {
                        name: exportParameters.customProfileName,
                        formatting: {
                            frontCover: exportParameters.frontCover,
                            backCover: exportParameters.backCover,
                            toc: exportParameters.toc,
                            tocTitle: exportParameters.tocTitle,
                            tocLevel: exportParameters.tocLevel,
                            tocMode: exportParameters.tocMode,
                            pageNumbersArea: exportParameters.pageNumbersArea,
                            stylesheetId: exportParameters.stylesheetId,
                            headerFooters: exportParameters.headerFooters,
                            pageSettings: exportParameters.pageSettings,
                            unit: exportParameters.unit,
                            margins: exportParameters.margins,
                            fontResize: exportParameters.fontResize,
                            breakWord: exportParameters.breakWord,
                            separatePage: exportParameters.separatePage,
                            selectedFont: exportParameters.selectedFont,
                            additionalFonts: exportParameters.additionalFonts,
                            headingNumbering: exportParameters.headingNumbering
                        }
                    };
                    self.initCustomizeProfileDialog(customProfile);
                },
                error: function() {
                    alert("Can not initialize Content Exporter!");
                }
            }).always(function() {
                MIJS.enableControls(self.disabledControls);
                MIJS.stopSpin(self.spinner);
            });
        },

        initCustomizeProfileDialog: function(profile){
            profile.space = AJS.$("#spaceKey").val();
            profile.name = "Custom";
            AJS.CONTENT_EXPORTER.PROFILE.init(profile, {
                width: 900,
                height: 630,
                mode: "customize",
                params: this.options.params,
                urls:{
                    coverPageSearch: this.options.urls.coverPageSearch,
                    coverPageLoad: this.options.urls.coverPageLoad
                },
                onClose: function(dialog) {
                    AJS.CONTENT_EXPORTER.PROFILE.closeProfileDialog();
                }
            });
        },

        updateContentSelector: function() {
            var exportType = this.exportParameters.exportContentType;
            var form = this.exportDialogNode.find("#content-exporter-ajax-form");
            var treeContainer = form.find("#tree-container");
            var rootContainer = form.find("#root-container");

            form.find("#export-type-select").val(exportType);

            if ((exportType == 'TREE')) {
                treeContainer.show();
                rootContainer.hide();
            }
            else {
                treeContainer.hide();
                rootContainer.show();
            }
            if("TREE" == exportType){
                form.find("#filter-label-container").show();
            }
            else{
                form.find("#filter-label-container").hide();
            }
        },

        updateProfileSelector: function(){
            var profileSelector = AJS.$("#profile");

            AJS.$("#profile option[value='']").remove();
            if(this.exportParameters.customProfileName){
                var newOption = AJS.$("<option></option>");
                newOption.val("");
                newOption.html(this.exportParameters.customProfileName);
                profileSelector.append(newOption);
            }

            var profileId = this.exportParameters.profileId;
            var profileExists = profileSelector.find("option[value='" + this.exportParameters.profileId + "']").length > 0;
            if(profileId && profileExists){
                profileSelector.val(profileId);
            }
            else if(this.exportParameters.customProfileName) {
                profileSelector.val("");
            }
            else {
                profileSelector.val("-1");
            }
        },

        applyLabelFilter: function() {
            var filterLabel = this.exportDialogNode.find("#label-filter-input");
            var treeContainer = this.exportDialogNode.find("#tree-container");
            var self = this;
            if (filterLabel.val() > "") {
                AJS.log("Doing label filter: " + filterLabel.val());
                AJS.$("#label-filter-spinner").show();
                AJS.$.ajax({
                    url: this.options.urls.labelFilterUrl,
                    data: AJS.$.extend({}, this.options.params, {labels: filterLabel.val()}),
                    type: "POST",
                    cache: false,
                    dataType: "json",
                    success: function(jsonResponse) {
                        AJS.log("FILTERED: " + jsonResponse);
                        treeContainer.find("input[type=checkbox]").prop("checked", false);
                        for (i = 0; i < jsonResponse.length; i++) {
                            var pageId = jsonResponse[i];
                            treeContainer.find("input[value=" + pageId + "]").prop("checked", true);
                        }
                        self.updateExportButton();
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        self.showError(self.createErrorMessage("Sorry, filtering by label failed!", jqXHR));
                        AJS.log("Label filtering error: " + textStatus + ", " + errorThrown);
                    },
                    complete: function() {
                        AJS.$("#label-filter-spinner").hide();
                    }
                });
            }
        },

        updateExportButton: function() {
            var allowExport = false;
            if (this.options.licensed) {
                var contentSelector = this.exportDialogNode.find("#export-type-select").val();
                if (contentSelector == "PAGE" || "ALL_CHILD" == contentSelector) {
                    allowExport = true;
                }
                else {
                    allowExport = this.exportDialogNode.find("#tree-container input.checkbox:checked:enabled").length > 0;
                }
            }
            this.exportDialogNode.find(".content-exporter-export-button").prop("disabled", !allowExport);
        },

        poll: function() {
            AJS.log("Polling for export");
            var self = this;
            AJS.$.ajax({
                url: this.options.urls.pollUrl,
                type: "GET",
                data: this.options.params,
                dataType: "json",
                cache: false,
                success: function(jsonResponse, textStatus, jqXHR) {
                    if (jsonResponse.ready) {
                        if(jsonResponse.success){
                            AJS.$("#progress-message").html("<p>Finished</p>");
                            AJS.$('#content-exporter-progressbar').attr("value","100");
                            self.download();
                        }
                        else {
                            AJS.log("Export error: " + jqXHR.responseText);
                            self.exportProgressDialog.hide();
                            self.showError(self.createErrorMessage("Sorry, could not perform export!", jqXHR), self);
                        }
                    }
                    else {
                    if(jsonResponse.progress && jsonResponse.progress.phase){
                        AJS.log("poll response phase: "+jsonResponse.progress.phase);
                        AJS.$("#progress-message").html(this.formatProgressMessage(jsonResponse.progress))
                     }
                        if(jsonResponse.progress.progressValue && jsonResponse.progress.progressValue != "-1"){
                            AJS.log("poll response progressValue: "+jsonResponse.progress.progressValue);
                            AJS.$('#content-exporter-progressbar').removeAttr("indeterminate","");
                            AJS.$('#content-exporter-progressbar').attr("value",jsonResponse.progress.progressValue);
                        } else {
                            AJS.$('#content-exporter-progressbar').attr("indeterminate","");
                        }
                        setTimeout(function() {
                            self.poll()
                        }, 1000);
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    AJS.log("Poll error: " + textStatus + ", " + errorThrown);
                    self.exportProgressDialog.hide();
                    self.showError(self.createErrorMessage("Sorry, can not check export state, download is unavailable!", jqXHR), self);
                },
                formatProgressMessage: function(progress) {
                    //workaround until AJS.I18n is not working
                    switch(progress.phase.toLowerCase()){
                        case 'fetching_pages':
                                text = 'Fetching pages';
                            break;
                        case 'generating_pages':
                                text = 'Generating pages';
                            break;
                        case 'generating_pages_with_full_page_numbers':
                                text = 'Generating pages (full page numbers)';
                            break;
                        case 'converting_pages':
                                text = 'Converting pages';
                            break;
                    }
                   // return "<p>"+AJS.I18n.getText('hu.metainf.plugin.confluence.contentexporter.progress.phase.'+progress.phase.toLowerCase())+"</p>";
                   return "<p>"+text+"</p>";
                }
            });
        },

        initExport: function(postData) {
            AJS.log(new Date() + " initExport called with data: " + JSON.stringify(postData));

            var self = this;

            if (this.exportDialog) {
                this.exportDialog.hide();
            }
            this.exportProgressDialog.show();

            AJS.$.ajax({
                url: this.options.urls.initExportUrl,
                type: "POST",
              //  timeout: 600000, // 10 minutes
                data: postData,
                cache: false,
                dataType: "json",
                success: function(jsonResponse) {
                    AJS.log("Hash: " + jsonResponse.hash);
                    self.options.params.hash = jsonResponse.hash;
                    self.poll();
                    self.doExport();
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    AJS.log(new Date() + " Init export error: " + textStatus + ", " + errorThrown);
                    self.exportProgressDialog.hide();
                    self.showError(self.createErrorMessage("Sorry, can not init export!", jqXHR), self);
                }
            });
        },
        doExport: function() {
            AJS.log(new Date() + " doExport called with hash: " + this.options.params.hash);

            var self = this;

            AJS.$.ajax({
                url: this.options.urls.exportUrl,
                type: "GET",
                timeout: 600000, // 10 minutes
                data: this.options.params,
                cache: false,
                dataType: "json",
                error: function(jqXHR, textStatus, errorThrown) {
                    AJS.log(new Date() + " Start export error: " + textStatus + ", " + errorThrown);
                    self.exportProgressDialog.hide();
                    self.showError(self.createErrorMessage("Sorry, can not start export!", jqXHR), self);
                }
            });
        },
        download: function() {
            AJS.log("Downloading file: " + this.options.params.hash);
            var src = this.options.urls.downloadUrl;
            src = src + (src.indexOf('?') > 0 ? '&' : '?') + AJS.$.param(this.options.params);
            if (this.iframe && this.iframe.length > 0) {
                this.iframe.remove();
            }
            this.iframe = AJS.$('<iframe>')
                    .hide()
                    .prop('src', src)
                    .appendTo('body');
            setTimeout(function() {
                AJS.CONTENT_EXPORTER.checkDownloadStarted();
            }, 500);
        },

        checkDownloadStarted: function() {
            AJS.log("check download: " + document.cookie);
            var cookieName = 'content-export-' + this.options.params.hash;
            if (document.cookie.indexOf(cookieName + '=success') >= 0) {
                document.cookie = cookieName + "=; path=/; expires=" + new Date(0).toUTCString();
                setTimeout(function() {
                    AJS.CONTENT_EXPORTER.closeAll(AJS.CONTENT_EXPORTER.exportProgressDialog);
                }, 100);
            }
            else if (this.checkDownloadFailed()) {
                var self=this;
                setTimeout(function() {
                    var iframeDoc = self.iframe[0].contentWindow || self.iframe[0].contentDocument;
                    if (iframeDoc.document) {
                        iframeDoc = iframeDoc.document;
                    }
                    AJS.log("iframeDoc: " + iframeDoc);

                    AJS.CONTENT_EXPORTER.showError(
                            AJS.CONTENT_EXPORTER.jsonToErrorMessage("Sorry, download failed! Please contact your administrator!<br/>" +
                            "Export identifier: " + AJS.CONTENT_EXPORTER.options.params.hash, JSON.parse(iframeDoc.body.innerText)),
                            AJS.CONTENT_EXPORTER);
                    // AJS.CONTENT_EXPORTER.showError(
                    //         "Sorry, download failed! Please contact your administrator!<br/>" +
                    //         "Error identifier: " + AJS.CONTENT_EXPORTER.options.params.hash, AJS.CONTENT_EXPORTER);
                }, 100);
            }
            else {
                setTimeout(function() {
                    AJS.CONTENT_EXPORTER.checkDownloadStarted();
                }, 500);
            }
        },

        checkDownloadFailed: function() {
            try {
                var iframeDoc = this.iframe[0].contentWindow || this.iframe[0].contentDocument;
                if (iframeDoc.document) {
                    iframeDoc = iframeDoc.document;
                }
                if (iframeDoc && iframeDoc.body !== null && iframeDoc.body.innerHTML.length) {
                    return true;
                }
            }
            catch (e) {
                return true;
            }
            return false;
        },

        closeAll: function(dialog) {
            if (this.options.onClose) {
                this.options.onClose(dialog);
            }
        },

        removeAllDialogs: function() {
            if (this.exportDialog) {
                this.exportDialog.remove();
                this.exportDialog = null;
            }
            if (this.exportProgressDialog) {
                this.exportProgressDialog.remove();
                this.exportProgressDialog = null;
            }
        }
    };
});
