/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import hu.metainf.plugin.confluence.contentexporter.dao.ExportProfileRepository;
import hu.metainf.plugin.confluence.contentexporter.dao.FontRepository;
import hu.metainf.plugin.confluence.contentexporter.exporter.Bookmarks;
import hu.metainf.plugin.confluence.contentexporter.exporter.ContentFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.ExportContext;
import hu.metainf.plugin.confluence.contentexporter.exporter.ImageFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.ResourceLoader;
import hu.metainf.plugin.confluence.contentexporter.exporter.css.CssProcessor;
import hu.metainf.plugin.confluence.contentexporter.exporter.css.TotalPageCountCssProcessor;
import hu.metainf.plugin.confluence.contentexporter.exporter.output.DocWriter;
import hu.metainf.plugin.confluence.contentexporter.exporter.output.HtmlWriter;
import hu.metainf.plugin.confluence.contentexporter.exporter.output.OutputWriter;
import hu.metainf.plugin.confluence.contentexporter.exporter.output.PdfMergeWriter;
import hu.metainf.plugin.confluence.contentexporter.exporter.output.PdfWriter;
import hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor.DocImageProcessor;
import hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor.PageProcessor;
import hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor.PdfImageProcessor;
import hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor.PdfInfoMacroProcessor;
import hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor.doc.JiraIssueCssCleanerProcessor;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluencePage;
import hu.metainf.plugin.confluence.contentexporter.model.Formatting;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum OutputFormat {
    DOC("doc", "application/msword"){

        @Override
        public List<PageProcessor> getProcessors(ImageFetcher imageFetcher) {
            return Arrays.asList(new DocImageProcessor(imageFetcher), new JiraIssueCssCleanerProcessor());
        }

        @Override
        public OutputWriter getOutputWriterInstance(FontRepository fontRepository, ExportProfileRepository profileRepository, ResourceLoader resourceLoader, ContentFetcher contentFetcher, Formatting formatting, Bookmarks bookmarks, Long rootContentId, List<ConfluencePage> pageList, ConfluencePage frontCoverPage, ConfluencePage backCoverPage) {
            return new DocWriter(formatting, bookmarks, pageList);
        }
    }
    ,
    PDF("pdf", "application/pdf"){

        @Override
        public List<String> getCssFiles() {
            return Arrays.asList("pdf.css", "icon-pdf.css");
        }

        @Override
        public List<PageProcessor> getProcessors(ImageFetcher imageFetcher) {
            return Arrays.asList(new PdfInfoMacroProcessor(), new PdfImageProcessor(imageFetcher));
        }

        @Override
        public OutputWriter getOutputWriterInstance(FontRepository fontRepository, ExportProfileRepository profileRepository, ResourceLoader resourceLoader, ContentFetcher contentFetcher, Formatting formatting, Bookmarks bookmarks, Long rootContentId, List<ConfluencePage> pageList, ConfluencePage frontCoverPage, ConfluencePage backCoverPage) {
            return new PdfWriter(fontRepository, profileRepository, formatting, bookmarks, pageList);
        }
    }
    ,
    PDF_MERGE("pdf", "application/pdf"){
        private static final String DUMMY_URL_PREFIX = "http://unresolved.meta-inf.hu/";

        @Override
        public String getLinkPrefix(long pageId) {
            return DUMMY_URL_PREFIX;
        }

        @Override
        public List<String> getCssFiles() {
            return Arrays.asList("pdf-merge.css.vm", "icon-pdf.css");
        }

        @Override
        public Map<String, CssProcessor> getCssProcessors(ExportContext exportContext) {
            HashMap<String, CssProcessor> result = new HashMap<String, CssProcessor>();
            result.put("pdf-merge.css.vm", new TotalPageCountCssProcessor(exportContext));
            return result;
        }

        @Override
        public List<PageProcessor> getProcessors(ImageFetcher imageFetcher) {
            return PDF.getProcessors(imageFetcher);
        }

        @Override
        public OutputWriter getOutputWriterInstance(FontRepository fontRepository, ExportProfileRepository profileRepository, ResourceLoader resourceLoader, ContentFetcher contentFetcher, Formatting formatting, Bookmarks bookmarks, Long rootContentId, List<ConfluencePage> pageList, ConfluencePage frontCoverPage, ConfluencePage backCoverPage) {
            return new PdfMergeWriter(fontRepository, profileRepository, formatting, bookmarks, pageList);
        }
    }
    ,
    HTML("zip", "application/zip"){

        @Override
        public String getLinkPrefix(long pageId) {
            return HtmlWriter.getFileName(pageId);
        }

        @Override
        public List<String> getCssFiles() {
            return Arrays.asList("html.css", "icon-html.css");
        }

        @Override
        public List<PageProcessor> getProcessors(ImageFetcher imageFetcher) {
            return Collections.singletonList(new PdfImageProcessor(imageFetcher));
        }

        @Override
        public OutputWriter getOutputWriterInstance(FontRepository fontRepository, ExportProfileRepository profileRepository, ResourceLoader resourceLoader, ContentFetcher contentFetcher, Formatting formatting, Bookmarks bookmarks, Long rootContentId, List<ConfluencePage> pageList, ConfluencePage frontCoverPage, ConfluencePage backCoverPage) {
            return new HtmlWriter(contentFetcher, resourceLoader, rootContentId, frontCoverPage, backCoverPage, pageList);
        }
    };

    private final String extension;
    private final String contentType;

    private OutputFormat(String extension, String contentType) {
        this.extension = extension;
        this.contentType = contentType;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getContentType() {
        return this.contentType;
    }

    @JsonCreator
    public static OutputFormat getByKey(String key) {
        return OutputFormat.valueOf(key.toUpperCase());
    }

    public abstract List<PageProcessor> getProcessors(ImageFetcher var1);

    public abstract OutputWriter getOutputWriterInstance(FontRepository var1, ExportProfileRepository var2, ResourceLoader var3, ContentFetcher var4, Formatting var5, Bookmarks var6, Long var7, List<ConfluencePage> var8, ConfluencePage var9, ConfluencePage var10);

    public List<String> getCssFiles() {
        return Collections.emptyList();
    }

    public String getLinkPrefix(long pageId) {
        return "";
    }

    public Map<String, CssProcessor> getCssProcessors(ExportContext exportContext) {
        return Collections.emptyMap();
    }
}

