/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor;

import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.exporter.ExportContext;
import hu.metainf.plugin.confluence.contentexporter.exporter.ImageFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.Images;
import hu.metainf.plugin.confluence.contentexporter.exporter.io.IoUtil;
import hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor.ImageDimension;
import hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor.PageProcessor;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluenceContent;
import hu.metainf.plugin.confluence.contentexporter.model.Statistics;
import hu.metainf.plugin.confluence.contentexporter.util.HtmlCleanerUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.IOUtils;
import org.htmlcleaner.TagNode;

public abstract class ImageProcessor
extends PageProcessor {
    private static Logger logger = Logger.getLogger(ImageProcessor.class);
    private static final byte[] MAGIC_GIF = new byte[]{71, 73, 70, 56};
    private static final byte[] MAGIC_JPG = new byte[]{-1, -40, -1};
    private static final byte[] MAGIC_PNG = new byte[]{-119, 80, 78, 71};
    private static final String TEMP_IMAGE_PREFIX = "temp_img_";
    private int tempImageCounter = 1;
    private Map<String, ImageDimension> imageDimensionCache = new HashMap<String, ImageDimension>();
    private ImageFetcher imageFetcher;

    public ImageProcessor(ImageFetcher imageFetcher) {
        this.imageFetcher = imageFetcher;
    }

    protected abstract void processImage(TagNode var1, File var2, ExportContext var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImageDimension getImageDimension(File imageFile) {
        String path = imageFile.getAbsolutePath();
        if (this.imageDimensionCache.containsKey(path)) {
            return this.imageDimensionCache.get(path);
        }
        ImageDimension result = null;
        ImageReader imgReader = null;
        try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(imageFile);){
            Iterator<ImageReader> imgReaders = ImageIO.getImageReaders(imageInputStream);
            if (imgReaders.hasNext()) {
                imgReader = imgReaders.next();
                imgReader.setInput(imageInputStream);
                result = new ImageDimension(imgReader.getWidth(0), imgReader.getHeight(0));
            }
        }
        catch (Throwable e) {
            logger.warn("Can't determine image size: {}", new Object[]{imageFile.getName(), e});
        }
        finally {
            if (imgReader != null) {
                imgReader.dispose();
            }
        }
        this.imageDimensionCache.put(path, result);
        return result;
    }

    @Override
    public void process(ConfluenceContent page, TagNode rootNode, TagNode viewNode, ExportContext exportContext, Statistics statistics) {
        Images images = exportContext.getImages();
        File workingDirectory = exportContext.getWorkingDirectory();
        List imgNodes = rootNode.getElementListByName("img", true);
        for (TagNode imgNode : imgNodes) {
            String src = imgNode.getAttributeByName("src");
            if (src == null || src.trim().isEmpty()) continue;
            String imageName = images.getImageFileNameBySrc(src);
            if (imageName == null && (imageName = this.saveImage(workingDirectory, src, images, statistics)) == null) {
                imageName = images.addUnavailableImage(src);
            }
            HtmlCleanerUtil.addOrReplaceAttribute(imgNode, "src", imageName);
            this.processImage(imgNode, new File(workingDirectory, imageName), exportContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String saveImage(File workingDirectory, String sourceUrl, Images images, Statistics statistics) {
        String tempImageName = TEMP_IMAGE_PREFIX + Integer.toString(this.tempImageCounter++);
        File tempImageFile = new File(workingDirectory, tempImageName);
        logger.debug("Saving image to " + tempImageFile.getAbsolutePath() + " from " + sourceUrl);
        InputStream is = this.imageFetcher.createImageInputStream(sourceUrl);
        if (is == null) {
            logger.warn("Image resource not found: " + sourceUrl);
            return null;
        }
        try {
            IoUtil.copy(is, tempImageFile);
        }
        catch (Exception e) {
            logger.warn("Can't save image file: " + tempImageName, (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        if (!tempImageFile.exists()) {
            return null;
        }
        long size = tempImageFile.length();
        statistics.addImage(size);
        String imageFormat = this.detectImageFormat(tempImageFile);
        if (imageFormat == null) {
            return null;
        }
        String imageName = images.addImage(sourceUrl, imageFormat);
        File finalImageFile = new File(workingDirectory, imageName);
        logger.debug("Final image file: {}", new Object[]{finalImageFile.getAbsolutePath()});
        if (!tempImageFile.renameTo(finalImageFile)) {
            logger.warn("Failed to rename to final image file: {}", new Object[]{finalImageFile.getAbsolutePath()});
            imageName = null;
        }
        return imageName;
    }

    public String detectImageFormat(File image) {
        String result = null;
        try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(image);){
            Iterator<ImageReader> imageReaders;
            if (null != imageInputStream && (imageReaders = ImageIO.getImageReaders(imageInputStream)).hasNext()) {
                result = imageReaders.next().getFormatName();
            }
        }
        catch (IOException e) {
            logger.error("Unable to detect the image format of the file (" + e.getMessage() + ") " + image.getAbsolutePath());
        }
        if (null == result) {
            logger.error("No ImageIO reader is available to detect the image format of the file " + image.getAbsolutePath());
        }
        return result;
    }

    private static boolean compareBytes(byte[] magicNumbers, byte[] buffer) {
        for (int i = 0; i < magicNumbers.length; ++i) {
            if (magicNumbers[i] == buffer[i]) continue;
            return false;
        }
        return true;
    }
}

