/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.output;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class HtmlTagBuilder {
    public static final String HTML_CLOSE = HtmlTagBuilder.tagClose("html").toString();
    public static final String DIV_CLOSE = HtmlTagBuilder.tagClose("div").toString();
    public static final String BODY_CLOSE = HtmlTagBuilder.tagClose("body").toString();
    public static final String A_CLOSE = HtmlTagBuilder.tagClose("a").toString();
    private final String tagName;
    private boolean isOpen = true;
    private boolean isEmpty = false;
    private Map<String, String> attributes = new HashMap<String, String>();
    private static final String OPEN_TAG = "<";
    private static final String CLOSE_TAG = ">";

    public static HtmlTagBuilder HTML() {
        return HtmlTagBuilder.tag("html");
    }

    public static HtmlTagBuilder DIV() {
        return HtmlTagBuilder.tag("div");
    }

    public static HtmlTagBuilder BODY() {
        return HtmlTagBuilder.tag("body");
    }

    public static HtmlTagBuilder A() {
        return HtmlTagBuilder.tag("a");
    }

    public HtmlTagBuilder id(String id) {
        return this.attribute("id", id);
    }

    public HtmlTagBuilder classs(String ... classs) {
        String oldClass = this.attributes.get("class") == null ? "" : this.attributes.get("class");
        return this.attribute("class", oldClass + (oldClass.length() > 0 && classs.length > 0 ? " " : "") + String.join((CharSequence)" ", Arrays.asList(classs)));
    }

    public HtmlTagBuilder href(String href) {
        return this.attribute("href", href);
    }

    public HtmlTagBuilder attribute(String name) {
        return this.attribute(name, null);
    }

    public HtmlTagBuilder attribute(String name, String value) {
        this.attributes.put(name, value);
        return this;
    }

    public static HtmlTagBuilder tagClose(String tagName) {
        return HtmlTagBuilder.tag(tagName).setClose();
    }

    public static HtmlTagBuilder tag(String tagName) {
        return new HtmlTagBuilder(tagName);
    }

    private HtmlTagBuilder(String tagName) {
        this.tagName = tagName;
    }

    public HtmlTagBuilder setEmpty() {
        this.isEmpty = true;
        return this;
    }

    private HtmlTagBuilder setClose() {
        this.isOpen = false;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isOpen) {
            sb.append(OPEN_TAG).append(this.tagName);
            for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
                if (null != attribute.getValue()) {
                    sb.append(" ").append((Object)attribute.getKey()).append("='").append((Object)attribute.getValue()).append("'");
                    continue;
                }
                sb.append(" ").append((Object)attribute.getKey());
            }
            if (this.isEmpty) {
                sb.append("/");
            }
            sb.append(CLOSE_TAG);
        } else {
            sb.append(OPEN_TAG).append("/").append(this.tagName).append(CLOSE_TAG);
        }
        return sb.toString();
    }
}

