/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter;

import hu.metainf.plugin.util.ErrorCollection;
import java.util.List;

public class OperationResult<T> {
    private T data;
    private ErrorCollection errors = new ErrorCollection();

    public OperationResult() {
    }

    public OperationResult(T data) {
        this.data = data;
    }

    public OperationResult(ErrorCollection errorCollection) {
        this.errors = errorCollection;
    }

    public OperationResult(String key, String message, List<Object> parameters) {
        this.addError(key, message, parameters);
    }

    public OperationResult(String key, String message) {
        this.addError(key, message);
    }

    public boolean isSuccess() {
        return !this.errors.hasAnyErrorMessages();
    }

    public void addError(String key, String message) {
        this.errors.addErrorMessage(key, message);
    }

    public void addError(String key, String message, List<Object> arguments) {
        this.errors.addErrorMessage(key, message, arguments);
    }

    public void addGlobalError(String message) {
        this.errors.addGlobalErrorMessage(message);
    }

    public void addGlobalError(String message, List<Object> arguments) {
        this.errors.addGlobalErrorMessage(message, arguments);
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public ErrorCollection getErrors() {
        return this.errors;
    }

    public void addGlobalErrorDetails(String details, List<Object> arguments) {
        this.errors.addGlobalErrorDetails(details, arguments);
    }

    public void addGlobalErrorDetails(String details) {
        this.errors.addGlobalErrorDetails(details);
    }

    public String getGlobalError() {
        return this.errors.getGlobalErrorMessage();
    }

    public String getGobalErrorDetails() {
        return this.errors.getGlobalErrorDetails();
    }
}

