/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter;

import hu.metainf.plugin.confluence.contentexporter.exporter.Bookmarks;
import hu.metainf.plugin.confluence.contentexporter.exporter.ContentFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.ImageFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.Images;
import hu.metainf.plugin.confluence.contentexporter.exporter.ResourceLoader;
import hu.metainf.plugin.confluence.contentexporter.model.Metadata;
import hu.metainf.plugin.confluence.contentexporter.model.OutputFormat;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExportContext {
    private String baseUrl;
    private File tempDirectory;
    private File workingDirectory;
    private ContentFetcher contentFetcher;
    private ImageFetcher imageFetcher;
    private ResourceLoader resourceLoader;
    private Bookmarks bookmarks;
    private Images images;
    private final Metadata metadata;
    private final OutputFormat outputFormat;
    private long totalPageCount;
    private Map<String, String> styles = new LinkedHashMap<String, String>();

    public ExportContext(String baseUrl, File tempDirectory, File workingDirectory, ContentFetcher contentFetcher, ImageFetcher imageFetcher, ResourceLoader resourceLoader, Bookmarks bookmarks, Images images, Metadata metadata, OutputFormat outputFormat) {
        this.baseUrl = baseUrl;
        this.tempDirectory = tempDirectory;
        this.workingDirectory = workingDirectory;
        this.contentFetcher = contentFetcher;
        this.imageFetcher = imageFetcher;
        this.resourceLoader = resourceLoader;
        this.bookmarks = bookmarks;
        this.images = images;
        this.metadata = metadata;
        this.outputFormat = outputFormat;
    }

    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public File getTempDirectory() {
        return this.tempDirectory;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public ContentFetcher getContentFetcher() {
        return this.contentFetcher;
    }

    public ImageFetcher getImageFetcher() {
        return this.imageFetcher;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public Bookmarks getBookmarks() {
        return this.bookmarks;
    }

    public Images getImages() {
        return this.images;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Map<String, String> getStyles() {
        return Collections.unmodifiableMap(this.styles);
    }

    public void addStyle(String newPlaceholder, String css) {
        this.styles.put(newPlaceholder, css);
    }

    public long getTotalPageCount() {
        return this.totalPageCount;
    }

    public void setTotalPageCount(long totalPageCount) {
        this.totalPageCount = totalPageCount;
    }
}

