/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.controllers;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.xwork.ParameterSafe;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import hu.metainf.plugin.confluence.contentexporter.controllers.ActionUtil;
import hu.metainf.plugin.confluence.contentexporter.controllers.ErrorToJsonConverter;
import hu.metainf.plugin.confluence.contentexporter.controllers.MessageResolver;
import hu.metainf.plugin.confluence.contentexporter.model.CoverPage;
import hu.metainf.plugin.confluence.contentexporter.service.ExportProfileService;
import hu.metainf.plugin.util.ErrorCollection;
import java.io.IOException;
import java.util.List;

public class CoverPageAction
extends ConfluenceActionSupport {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private transient ExportProfileService exportProfileService;
    private String term;
    private String spaceKey;
    private Long id;

    public void setExportProfileService(ExportProfileService exportProfileService) {
        this.exportProfileService = exportProfileService;
    }

    public String createGlobalCoversSpace() throws IOException {
        ObjectNode result = this.objectMapper.createObjectNode();
        try {
            this.exportProfileService.createGlobalCoversSpace();
            result.put("status", "success");
        }
        catch (Exception e) {
            ErrorCollection errorCollection = new ErrorCollection();
            errorCollection.addGlobalErrorMessage(e.getMessage());
            JsonNode jsonNode = new ErrorToJsonConverter(new MessageResolver(this.getI18n())).toJson(errorCollection);
            result.set("errors", jsonNode);
            result.put("status", "invalid-data");
        }
        ActionUtil.sendJsonResponse((JsonNode)result);
        return "success";
    }

    public String search() throws IOException {
        List<CoverPage> coverPages = this.exportProfileService.getCoverPages(this.term, this.spaceKey);
        ActionUtil.sendJsonResponse(this.objectMapper.writeValueAsString(coverPages));
        return "none";
    }

    public String load() throws IOException {
        CoverPage coverPage = this.exportProfileService.getCoverPage(this.id);
        ActionUtil.sendJsonResponse(this.objectMapper.writeValueAsString((Object)coverPage));
        return "none";
    }

    @ParameterSafe
    public void setTerm(String term) {
        this.term = term;
    }

    @ParameterSafe
    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    @ParameterSafe
    public void setId(Long id) {
        this.id = id;
    }
}

