var MIJS = MIJS || {};
MIJS.DLG_OK = "ok";
MIJS.DLG_CANCEL = "cancel";

$(function() {
    AJS.log("meta-inf-common.js");
    // AJS.$(document).on('keydown', function(e) {
    //     // Disable form submission on ENTER
    //     if (e.keyCode === 13 && AJS.$(e.target).is("input")) {
    //         e.preventDefault();
    //     }
    //
    //     // Close current dialog on ESC
    //     if (e.keyCode === 27 && !MIJS.codeMirrorAutocompleteActive) {
    //
    //         var currentDialog = AJS.layer.Manager.global.getTopLayer();
    //         if (currentDialog != null) {
    //             AJS.dialog2(currentDialog).remove();
    //             e.preventDefault();
    //         }
    //     }
    // });

    AJS.bind("show.dialog", function(e, data) {
        AJS.log("show.dialog");
        MIJS.updateBlanket();
    });

    AJS.bind("hide.dialog", function(e, data) {
        AJS.log("hide.dialog");
        MIJS.updateBlanket();
    });

    AJS.bind("remove.dialog", function(e, data) {
        AJS.log("remove.dialog");
        MIJS.updateBlanket();
    });

    MIJS.appendTokenToUrl = function(url)
    {
        if (url.indexOf("?acpt=") > 0 || url.indexOf("&acpt=") > 0) {
            return url;
        }
        return (url.indexOf("?") > 0)
            ? url + "&acpt=" + AJS.JETI.navigation.currentToken()
            : url + "?acpt=" + AJS.JETI.navigation.currentToken();
    }

    // Ajax functions

    MIJS.ajaxOptions = {};

    //MIJS.resetForm = function(form) {
    //    form.find('div.error').empty();
    //}
    //
    //MIJS.setFormErrors = function(form, errors) {
    //    $.each(errors, function() {
    //        var e = form.find('div#error-' + this.key);
    //        e.html(this.message);
    //    });
    //
    //}

    MIJS.ajaxSetup = function(opts) {
        MIJS.ajaxOptions = opts;
    }

    MIJS.ajax = function(method, url, settings) {
        if (settings == undefined) {
            settings = {}
        }

        var deferred = $.Deferred();
        var promise = deferred.promise();

        var payload = {
            url: url,
            method: method,
            headers: {
                "X-acpt": AJS.JETI.navigation.currentToken()
            },
            cache: false
        };

        if (settings.data != undefined) {
            payload.data = settings.data;
        }

        if (settings && settings.dialog) {
            settings.spinner = settings.dialog.find(".aui-dialog2-footer .button-spinner");
            settings.disableControls = settings.dialog.find(".aui-button").not('.aui-button-link');
        }

        var disabledControls = [];
        if (settings && settings.disableControls) {
            AJS.$(settings.disableControls).each(function() {
                var control = AJS.$(this);
                if (!control.prop("disabled")) {
                    disabledControls.push(this);
                    control.prop("disabled", true);
                }
            })
        }
        if (settings && settings.spinner) {
            MIJS.startSpin(settings.spinner);
        }

        var jqXHR = $.ajax(payload)
                .done(function(data, textStatus, jqXHR) {
                    deferred.resolve.apply(this, arguments);
                    //var contentType = jqXHR.getResponseHeader('Content-Type');
                    //var isHtml = (contentType.indexOf('text/html') === 0);
                    //var expireType = "";
                    //if (isHtml && data.indexOf('dologin.action') > 0) {
                    //    expireType = "session";
                    //}
                    //else if (isHtml && data.indexOf('doauthenticate.action') > 0) {
                    //    expireType = "websudo";
                    //}
                    //
                    //if (expireType > "") {
                    //    var expireHandler = MIJS.ajaxOptions.sessionExpired ? MIJS.ajaxOptions.sessionExpired() : window.location.href;
                    //    if ($.type(expireHandler) == "function") {
                    //        expireHandler(expireType);
                    //    }
                    //    else {
                    //        window.location.href = AJS.contextPath()
                    //                + (expireType == "session" ? "/login.action?os_destination=" : "/authenticate.action?destination=")
                    //                + encodeURI(expireHandler);
                    //    }
                    //}
                    //else {
                    //    deferred.resolve.apply(this, arguments);
                    //}
                })
                .fail(function(jqXHR, textStatus, errorThrown) {
                    var args = arguments;
                    if (settings.errorMessage != undefined) {
                        var errorMessage = settings.errorMessage;
                        if ($.type(errorMessage) === "string") {
                            errorMessage = errorMessage.replace(/\{status\}/g, jqXHR.status);
                            errorMessage = errorMessage.replace(/\{statusText\}/g, jqXHR.statusText);
                        }
                        else if (errorMessage.text > "") {
                            errorMessage.text = errorMessage.replace(/\{status\}/g, jqXHR.status);
                            errorMessage.text = errorMessage.replace(/\{statusText\}/g, jqXHR.statusText);
                        }

                        if (settings.renderErrorMessageIn !== undefined) {
                            MIJS.renderErrors(settings.renderErrorMessageIn, [{"key": null, "message": errorMessage}]);
                        }
                        else {
                            var errorDialog = MIJS.showErrorDialog(errorMessage);
                            args = $.merge(args, [ errorDialog ]);
                        }
                    }
                    deferred.reject.apply(this, args);
                })
                .always(function() {
                    if (disabledControls.length > 0) {
                        AJS.$(disabledControls).prop("disabled", false);
                    }
                    if (settings && settings.spinner) {
                        MIJS.stopSpin(settings.spinner);
                    }
                });

        return promise;
    }

    MIJS.get = function(url, settings) {
        return MIJS.ajax('GET', url, settings);
    }

    MIJS.post = function(url, settings) {
        return MIJS.ajax('POST', url, settings);
    }

    MIJS.del = function(url, settings) {
        return MIJS.ajax('DELETE', url, settings);
    }

    // AUI Messages

    MIJS.showAuiMessage = function(type, title, message) {
        AP.require("messages", function(messages) {
            switch (type) {
                case "success":
                    var auiMsg = messages.success(title, message);
                    break;
                case "error":
                    var auiMsg = messages.error(title, message);
                    break;
            }
            setTimeout(function(){
                messages.clear(auiMsg);
            }, 3000);
        });
    }

    // Workaround for AUI dialog2: if remove-on-hide is set, then calling "remove" on dialog2 throws an exception,
    // since "hide" already removes the content
    //AJS.dialog2.on('hide', function(e, dialogContent) {
    //    if (dialogContent.data("mijs-remove-dialog-content")) {
    //        dialogContent.remove();
    //        if (!AJS.$('section.aui-dialog2').is(':visible')) {
    //            AP.resize();
    //        }
    //    }
    //});

    MIJS.showErrorDialog = function(message) {
        var settings = {
            mode: "errorDialog",
            message: message
        }
        return MIJS.showIframeDialog("", settings);
    }

    MIJS.showConfirmDialog = function(message, callback) {
        var settings = {
            mode: "confirmationDialog",
            message: message
        }
        var dialog = MIJS.showIframeDialog("", settings);
        if (typeof callback == "function") {
            dialog.on("close", function(data) {
                if (data.result == "ok") {
                    callback();
                }
            });
        }
        return dialog;
    }

    MIJS.createDialogDom = function(content) {
        return AJS.$("<div></div>").append(content).find("section.aui-dialog2");
    }

    MIJS.showDialog = function(content) {
        var $dialogContent = AJS.$(content);
        $dialogContent.data("mijs-remove-dialog-content", "true");
        // Do not use auto-remove, see comment at "AJS.dialog2.on('hide'..."
        $dialogContent.removeData("aui-remove-on-hide");
        $dialogContent.removeAttr("data-aui-remove-on-hide");
        var id = $dialogContent.attr("id");

        $dialogContent.find(".aui-button-link").click(function(e) {
            dialog.remove();
        });

        var dialog = AJS.dialog2($dialogContent);
        dialog.show();

        if ($dialogContent.find("ol.aui-progress-tracker").length > 0) {
            MIJS.decorateDialogForProgressTracking($dialogContent);
        }

        var form = $dialogContent.find("form");
        if (form.length > 0) {
            MIJS.focusFirst(form);
        }

        //setTimeout(function() {
        //    AJS.log("BROWSER HEIGHT: " + AJS.$(window).height());
        //    ha itt van a dialog show, akkor kell egy init callback, hogy a select-ek mar a letezo DOM-ban tudjanak inicializalodni
        //}, 100);
        return dialog;
    }

    MIJS.decorateDialogForProgressTracking = function(dialogContent) {
        var $tracker = dialogContent.find("ol.aui-progress-tracker");
        var $trackerSteps = $tracker.find("li");
        var $pages = dialogContent.find("div.tab-page");
        var $backButton = dialogContent.find('.back-button');
        var $nextButton = dialogContent.find('.next-button');
        var lastStep = $trackerSteps.length - 1;

        $trackerSteps.find('a').on("click stepToTab", function(e, $focusElement) {
            var li = AJS.$(this).closest('li');
            stepTo($trackerSteps.index(li), $focusElement);
        });

        dialogContent.find('.back-button, .next-button').on("click", function() {
            var direction = AJS.$(this).hasClass('back-button') ? -1 : 1;
            var current = $trackerSteps.index($tracker.find(".aui-progress-tracker-step-current"));
            stepTo(current + direction);
        })

        function stepTo(index, $focusElement) {
            index = Math.max(0, Math.min(index, lastStep));
            $trackerSteps.removeClass("aui-progress-tracker-step-current");
            AJS.$($trackerSteps.get(index)).addClass("aui-progress-tracker-step-current");

            $pages.hide();
            var $currentPage = AJS.$($pages.get(index));
            $currentPage.show();
            MIJS.fixSelectPlaceholders($currentPage);
            if ($focusElement) {
                MIJS.focusFirst($focusElement);
            }
            else {
                MIJS.focusFirst($currentPage);
            }

            $backButton.prop("disabled", index == 0);
            $nextButton.prop("disabled", index == lastStep);
        }


        stepTo(0);
    }

    MIJS.fixSelectPlaceholders = function($root) {
        $root.find(".aui-select2-container").each(function() {
            var $sel2 = AJS.$(this);
            var $input = $sel2.find('input');
            var $ul = $input.closest("ul");
            // Only set input width if only the placeholder is shown (there is only 1 LI element
            if ($ul.find("li").length == 1 && $sel2.width() - $input.width() > 20) {
                $input.width(($sel2.width() - 20) + "px");
            }
        })
    }

    MIJS.showIframeDialog = function(url, settings) {
        customData = settings || {};
        customData.url = url;

        var result = null;
        AP.require('dialog', function (dialog) {
            result = dialog.create({
                key: 'mi-generic-dialog',
                width: '100%',
                height: '100%',
                chrome: false,
                customData: customData
            });
        });
        return result;
    }


    MIJS.closeIframeDialog = function(result, data) {
        AP.require('dialog', function(dialog){
            dialog.close({result: result, data: data});
        });
    }

    MIJS.updateBlanket = function()
    {
        var maxZ = 0;
        var $dialogs = AJS.$(".aui-dialog:visible");

        if (AJS.$(".aui-blanket:visible").length == 0) {
            AJS.$(".mi-blanket").remove();
            var last = $dialogs.length - 1;
            $dialogs.each(function(index) {
                if (index == last) {
                    return;
                }
                var css = {
                    "margin-top": $(this).css("margin-top"),
                    "margin-left": $(this).css("margin-left"),
                    "width": (parseInt($(this).css("width"), 10) + 2) + "px",
                    "height": (parseInt($(this).css("height"), 10) + 2) + "px",
                    "z-index": parseInt($(this).css("z-index"), 10) + 1
                };
                var $blanket = AJS.$("<div class='mi-blanket'></div>");
                $blanket.css(css);
                AJS.$("body").append($blanket);
            });
        }
        else if ($dialogs.length > 0) {
            $dialogs.each(function() {
                var z = parseInt($(this).css("z-index"), 10);
                if (z > maxZ) {
                    maxZ = z;
                }
            });
            AJS.$(".aui-blanket").css("z-index", maxZ - 1);
        }
    };

    // Error handling functions

    MIJS.resetFormMessages = function(containerSelector) {
        var container = AJS.$(containerSelector);
        container.find("div.error").empty();
        container.find(".aui-message").hide();
        container.find("ol.aui-progress-tracker li").removeClass("error-step");
        // Remove everything except title
        container.find(".aui-message").each(function() {
            var messageDiv = AJS.$(this);
            var title = messageDiv.find(".title");
            messageDiv.html(title);
        });
    }

    MIJS.renderSuccessMessage = function(containerSelector, message) {
        MIJS.resetFormMessages(containerSelector);
        var container = AJS.$(containerSelector);
        var messageDiv = container.find(".aui-message-success");
        messageDiv.append(AJS.$("<p></p>").html(message));
        messageDiv.show();
        focusErrorsInDialog(container);
    }

    /**
     * Renders errors as simple list of messages not bound to any input fields
     * @param containerSelector
     * @param errors
     */
    MIJS.renderErrorsAsMessage = function(containerSelector, errors) {
        MIJS.resetFormMessages(containerSelector);
        var container = AJS.$(containerSelector);
        var messageDiv = container.find(".aui-message-error");
        for (var i = 0; i < errors.length; i++) {
            messageDiv.append("<p>" + errors[i].message + "</p>");
        }
        messageDiv.show();
        focusErrorsInDialog(container);
    }

    MIJS.renderErrors = function(containerSelector, errors) {
        MIJS.resetFormMessages(containerSelector);
        var container = AJS.$(containerSelector);
        for (var i = 0; i < errors.length; i++) {
            var error = errors[i];
            var errorDiv = container.find(error.key > "" ? ("#error-" + error.key) : ".aui-message-error");
            errorDiv.append(AJS.$("<p></p>").html(error.message));
            if (error.key == null) {
                errorDiv.show();
            }
        }
        focusErrorsInDialog(container);
    }

    // If a dialog is shown, focus the first failed tab an highlight failed tabs
    // If a page is shown, resize it to make space the newly shown error messages

    function focusErrorsInDialog(dialog) {
        if(!AJS.layer.Manager){
            return;
        }
        var $currentDialog = AJS.$(AJS.layer.Manager.global.getTopLayer());
        if ($currentDialog == null) {
            return;
        }

        var $pages = $currentDialog.find('.tab-page');
        var $trackerSteps = null;
        var tabbedDialog = $pages.length > 0;
        if (tabbedDialog) {
            $trackerSteps = $currentDialog.find("ol.aui-progress-tracker li");
        }
        else {
            $pages = $currentDialog.find('.aui-dialog2-content');
        }

        var firstFailedPageIndex = -1;
        var $scrollTo = null;
        $pages.each(function(pageIndex) {
            var $page = AJS.$(this);
            var $firstFailedField = $page.find(".error:not(:empty)").first();
            if ($firstFailedField.length > 0) {
                if (tabbedDialog) {
                    AJS.$($trackerSteps.get(pageIndex)).addClass('error-step');
                }
                if (firstFailedPageIndex == -1) {
                    firstFailedPageIndex = pageIndex;
                    $scrollTo = $firstFailedField.parent();
                }
            }
        })

        var $globalMessage = $currentDialog.find(".aui-message:visible");
        if ($globalMessage.length > 0) {
            $scrollTo = $globalMessage.first();
        }

        if ($scrollTo != null) {
            if (tabbedDialog) {
                var $firstFailedTab = AJS.$($trackerSteps.get(firstFailedPageIndex));
                $firstFailedTab.find('a').trigger("stepToTab", $scrollTo);
            }
            $currentDialog.find('.aui-dialog2-content').scrollTo($scrollTo);
        }
    }

    MIJS.focusFirst = function(containerSelector) {
        setTimeout(function() {
            var $root = AJS.$(containerSelector);
            $root.find("input[type='text']:enabled:visible, textarea:enabled:visible, select:enabled:visible").first().focus();
        }, 100);
    }

    // Expand/Collapse toggle

    MIJS.rowToggler = function(selector, settings) {
        var $rowsWithToggle = AJS.$(selector);
        settings = settings || {};

        $rowsWithToggle.on("click", function(e) {
            if (AJS.$(e.target).closest('td').hasClass('no-row-toggle')) {
                return;
            }

            var $headerWithToggle = AJS.$(this);
            var $toggleIcon = $headerWithToggle.find('.row-toggle-icon');
            var expand = $toggleIcon.hasClass('row-toggle-collapsed');
            $toggleIcon.removeClass("row-toggle-expanded row-toggle-collapsed");
            $toggleIcon.addClass(expand ? 'row-toggle-expanded' : 'row-toggle-collapsed');
            var $detailsNode = settings.details ? AJS.$(settings.details) : $headerWithToggle.next("tr");
            $detailsNode.toggle();

            if (settings.ajaxContent) {
                if (expand) {
                    $detailsNode.find('td').empty().append('<div class="row-expand-spinner"></div>');
                    $detailsNode.find('.row-expand-spinner').spin();
                }
                else {
                    $detailsNode.remove('.row-expand-spinner');
                }
            }
            //AP.resize();
            $headerWithToggle.trigger(expand ? "expand" : "collapse", [ $headerWithToggle, $detailsNode ]);
        })

        var toggler = {
            on: function(event, fn) {
                $rowsWithToggle.on(event, fn);
            },

            off: function(event, fn) {
                $rowsWithToggle.off(event, fn);
            },

            toggle: function(selector) {
                AJS.$(selector).click();
            }
        };
        return toggler;
    }

    MIJS.toggleExpandCollapse = function(selector) {
        if (AJS.$(selector).length > 0) {
            AJS.$(selector).toggle();
            var toggleIcon = AJS.$(this).closest('tr').find('.toggle-icon');
            if (toggleIcon.length > 0) {
                if (toggleIcon.hasClass('aui-iconfont-arrow-down')) {
                    toggleIcon.removeClass('aui-iconfont-arrow-down').addClass('aui-iconfont-arrow-up');
                } else {
                    toggleIcon.removeClass('aui-iconfont-arrow-up').addClass('aui-iconfont-arrow-down');
                }
            }
            //AP.resize();
        }
    }


    // Spinner functions

    MIJS.disableControls = function(controls) {
        var disabledControls = [];
        if (controls) {
            AJS.$(controls).each(function() {
                var control = AJS.$(this);
                if (!control.prop("disabled")) {
                    disabledControls.push(this);
                    control.prop("disabled", true);
                }
            })
        }
        return disabledControls;
    };

    MIJS.enableControls = function(disabledControls) {
        if (disabledControls.length > 0) {
            AJS.$(disabledControls).prop("disabled", false);
        }
    };

    MIJS.startSpin = function(container) {
        var spinner = container.find(".button-spinner");
        if (spinner) {
            AJS.$(spinner).spin();
        }
        return spinner;
    };

    MIJS.stopSpin = function(spinner) {
        if(spinner){
            AJS.$(spinner).spinStop();
        }
    }

});
//# sourceURL=meta-inf-common.js