AJS.$.fn.extend({
    insertAtCursor: function(myValue) {
        return this.each(function(i) {
            if (document.selection) {
                //For browsers like Internet Explorer
                this.focus();
                sel = document.selection.createRange();
                sel.text = myValue;
                this.focus();
            }
            else if (this.selectionStart || this.selectionStart === '0') {
                //For browsers like Firefox and Webkit based
                var startPos = this.selectionStart;
                var endPos = this.selectionEnd;
                var scrollTop = this.scrollTop;
                this.value = this.value.substring(0, startPos) + myValue +
                        this.value.substring(endPos,this.value.length);
                this.focus();
                this.selectionStart = startPos + myValue.length;
                this.selectionEnd = startPos + myValue.length;
                this.scrollTop = scrollTop;
            } else {
                this.value += myValue;
                this.focus();
            }
        })
    }
});
AJS.toInit(function() {
    AJS.log("export-profiles");
    AJS.CONTENT_EXPORTER = AJS.CONTENT_EXPORTER || {};
    AJS.CONTENT_EXPORTER.PROFILE = {
        init: function(profile, options) {
            AJS.log("init profile dialog with profile: " + JSON.stringify(profile));
            this.profile = profile;
            this.options = options;

            AJS.log("mode: " + this.options.mode);
            if ("edit" === this.options.mode) {
                AJS.CONTENT_EXPORTER.headerAvatarTemplate = AJS.$(".content-exporter-header-avatar").remove();
            }
            this.profileDialogTemplate = AJS.$("#cex-profile-dialog-template").remove();
            this.stylesheetDialogTemplate = AJS.$('#cex-stylesheet-dialog-template').remove();
            this.advancedDialogTemplate = AJS.$('#cex-advanced-dialog-template').remove();
            this.headersFootersDialogTemplate = AJS.$('#cex-headers-footers-dialog-template').remove();
            this.tableOfContentsDialogTemplate = AJS.$('#cex-toc-template').remove();
            this.pageSettingsDialogTemplate = AJS.$('#cex-page-settings-dialog-template').remove();
            this.headerFooterHints = {
                "document.title" : "[DOCUMENT_TITLE]",
                "document.version" : "[DOCUMENT_VERSION]",
                "document.creationDate" : "[DOCUMENT_CREATED]",
                "document.lastModificationDate" : "[DOCUMENT_LAST_MODIFIED]",
                "paging.currentPageNo" : "[PAGE_NO]",
                "paging.totalPageNo" : "[TOTAL_PAGE_NO]",
                "creator.fullName" : "[CREATOR_FULL_NAME]",
                "creator.username" : "[CREATOR_USERNAME]",
                "lastModifier.fullName" : "[LAST_MODIFIER_FULL_NAME]",
                "lastModifier.username" : "[LAST_MODIFIER_USERNAME]",
                "export.date" : "[EXPORT_DATE]"};

            this.createProfileDialog();
            this.profileDialog.show();
        },

        updateProfileModel: function() {
            var profile = this.profile;
            profile.name = this.profileDialogNode.find("#name").val();
            profile.formatting.frontCover = AJS.$("#front-cover").val();
            profile.formatting.backCover = AJS.$("#back-cover").val();
            profile.formatting.toc = AJS.$("#table-of-contents").prop("checked");
        },

        createProfileDialog: function() {
            this.profileDialog = new AJS.Dialog({
                width: this.options.width,
                height: this.options.height,
                id: "cex-profile-dialog",
                closeOnOutsideClick: false,
                keypressListener: $.proxy(function(e) {
                    if (e.keyCode == 27) {
                        this.closeAll(this)
                    }
                }, this)
            });
            this.profileDialogNode = AJS.$("#"+this.profileDialog.id);

            this.profileDialog.addPanel("", this.profileDialogTemplate.clone(), "panel-body");

            if("edit" === this.options.mode){
                this.profileDialog.addHeader("Export Profile");
                if(AJS.Meta.get('access-mode') != "READ_ONLY"){
                    this.profileDialog.addButton("Save", $.proxy(function() {
                        this.updateProfileModel();
                        this.profileDialog.action = "save";
                        this.saveProfile();
                    }, this));
                }
            }
            else if("customize" === this.options.mode){
                this.profileDialog.addHeader("Customize Export Profile");
                this.profileDialogNode.find("#name-row").hide();
                this.profileDialog.addButton("Apply", $.proxy(function() {
                    this.updateProfileModel();
                    this.profileDialog.action = "customize";
                    this.updateExportParameters();
                }, this));
            }
            this.profileDialog.addLink("Cancel", $.proxy(function(dialog) {
                this.profileDialog.action = "cancel";
                this.closeAll(dialog);
            }, this), "#");

            this.profileDialogNode.find(".dialog-title").prepend(AJS.CONTENT_EXPORTER.headerAvatarTemplate.clone());
            this.profileDialogNode.find(".dialog-button-panel").prepend(AJS.$('<span class="button-spinner"></span>'));
            this.profileDialogNode.find(".dialog-button-panel").prepend(AJS.$('<span id="export-profile-summary" class="dialog-summary"></span>'));

            if("customize" === this.options.mode){
                this.profileDialogNode.find("#export-profile-summary").html("Customizations will be applied only for this export");
            }

            this.profileDialogNode.find("#export-select-stylesheet").click($.proxy(function(e) {
                this.showStylesheetSelectorDialog();
                e.preventDefault();
            }, this));

            this.profileDialogNode.find("#export-edit-headers-footers").click($.proxy(function(e) {
                this.showHeadersFootersDialog();
                e.preventDefault();
            }, this));

            this.profileDialogNode.find("#export-edit-page-settings").click($.proxy(function(e) {
                this.showPageSettingsDialog();
                e.preventDefault();
            }, this));

            this.profileDialogNode.find("#toc-edit").click($.proxy(function(e){
                this.showTableOfContentsDialog();
                e.preventDefault();
            }, this));

            this.profileDialogNode.find("#profile-advanced-edit").click($.proxy(function(e) {
                this.showAdvancedDialog();

                AJS.$("#additional-font-selector").auiSelect2({
                    minimumInputLength: 0
                });

                e.preventDefault();
            }, this));

            this.profileDialogNode.find(".number-only").keypress(function(e) {
                if(isNaN(this.value + "" + String.fromCharCode(e.charCode)))
                    return false;
            });

            this.profileDialogNode.find("#name").val(this.profile.name);
            this.profileDialogNode.find("#front-cover").val(this.profile.formatting.frontCover);
            this.profileDialogNode.find("#back-cover").val(this.profile.formatting.backCover);
            this.profileDialogNode.find("#table-of-contents").prop("checked", this.profile.formatting.toc);

            this.initPagePickers();
            this.updateStylesheetSummary();
            this.updatePageSettingsSummary();
            this.updateHeaderFooterSummary();
            this.updateTableOfContentsSummary();
            this.updateAdvancedSummary();
        },

        showTableOfContentsDialog: function(){
            this.tableOfContentsDialog = new AJS.Dialog({
                width: 800,
                height: 500,
                id: "cex-toc-dialog"
            });

            this.tableOfContentsDialog.addHeader("Table Of Contents");
            this.tableOfContentsDialog.addPanel("Advanced", this.tableOfContentsDialogTemplate.clone(), "panel-body");
            var tableOfContentsDialogNode = AJS.$("#"+this.tableOfContentsDialog.id);
            tableOfContentsDialogNode.find("#toc-title").val(this.profile.formatting.tocTitle);
            tableOfContentsDialogNode.find("#toc-level").val(this.profile.formatting.tocLevel);
            if (this.profile.formatting.tocMode === "FLAT") {
                tableOfContentsDialogNode.find(":radio[value=FLAT]").prop('checked', true);
                tableOfContentsDialogNode.find(":radio[value=HIERARCHICAL]").prop('checked', false);
            } else {
                tableOfContentsDialogNode.find(":radio[value=FLAT]").prop('checked', false);
                tableOfContentsDialogNode.find(":radio[value=HIERARCHICAL]").prop('checked', true);
            }
            tableOfContentsDialogNode.find("#toc-heading-numbering").prop("checked",this.profile.formatting.headingNumbering);

            if(AJS.Meta.get('access-mode') != "READ_ONLY" || "customize" === this.options.mode){
                this.tableOfContentsDialog.addButton("Apply", $.proxy(function(dialog) {
                    var buttonsContainer = tableOfContentsDialogNode.find(".dialog-button-panel");
                    MIJS.disableControls(buttonsContainer.find("button"));
                    MIJS.startSpin(buttonsContainer);

                    this.profile.formatting.tocTitle = tableOfContentsDialogNode.find("#toc-title").val();
                    this.profile.formatting.tocLevel = tableOfContentsDialogNode.find("#toc-level").val();
                    this.profile.formatting.tocMode = tableOfContentsDialogNode.find("input[name=toc-mode]:checked").val();
                    this.profile.formatting.headingNumbering=tableOfContentsDialogNode.find("#toc-heading-numbering").is(":checked");

                    this.updateTableOfContentsSummary();
                    this.closeTableOfContentsDialog();
                }, this));
            }

            this.tableOfContentsDialog.addCancel("Cancel", $.proxy(function (dialog) {
                this.closeTableOfContentsDialog();
            }, this));

            var buttonPanel = tableOfContentsDialogNode.find(".dialog-button-panel");
            buttonPanel.prepend(AJS.$('<span class="button-spinner"></span>'));

            this.tableOfContentsDialog.show();
        },

        selectedCustomFontExists: function() {
            return this.advancedDialogTemplate.find("#custom-font option[value='" + this.profile.formatting.selectedFont + "']").length > 0;
        },

        showAdvancedDialog: function() {
            this.advancedDialog = new AJS.Dialog({
                width: 800,
                height: 500,
                id: "cex-advanced-dialog"
            });

            this.advancedDialog.addHeader("Advanced Options");

            this.advancedDialog.addPanel("Advanced", this.advancedDialogTemplate.clone(), "panel-body");

            var advancedDialogNode = AJS.$("#"+this.advancedDialog.id);
            advancedDialogNode.find("#font-resize").prop("checked", this.profile.formatting.fontResize);
            advancedDialogNode.find("#break-word").prop("checked", this.profile.formatting.breakWord);
            advancedDialogNode.find("#separate-page").prop("checked", this.profile.formatting.separatePage);
            advancedDialogNode.find("#additional-font-selector").val(this.profile.formatting.additionalFonts);
            if(this.selectedCustomFontExists()) {
                advancedDialogNode.find("#custom-font").val(this.profile.formatting.selectedFont);
            }
            advancedDialogNode.find("#page-numbers-area-from").val(this.profile.formatting.pageNumbersArea.numbersFrom);
            advancedDialogNode.find("#page-numbers-area-to").val(this.profile.formatting.pageNumbersArea.numbersTo);

            if(AJS.Meta.get('access-mode') != "READ_ONLY" || "customize" === this.options.mode){
                this.advancedDialog.addButton("Apply", $.proxy(function(dialog) {
                    var buttonsContainer = advancedDialogNode.find(".dialog-button-panel");
                    MIJS.disableControls(buttonsContainer.find("button"));
                    MIJS.startSpin(buttonsContainer);

                    this.profile.formatting.fontResize = advancedDialogNode.find("#font-resize").prop("checked");
                    this.profile.formatting.breakWord = advancedDialogNode.find("#break-word").prop("checked");
                    this.profile.formatting.separatePage = advancedDialogNode.find("#separate-page").prop("checked");
                    this.profile.formatting.selectedFont = advancedDialogNode.find("#custom-font").val();
                    this.profile.formatting.additionalFonts = advancedDialogNode.find("#additional-font-selector").val();
                    this.profile.formatting.pageNumbersArea.numbersFrom = AJS.$("#page-numbers-area-from option:selected").val();
                    this.profile.formatting.pageNumbersArea.numbersTo = AJS.$("#page-numbers-area-to option:selected").val();

                    this.updateAdvancedSummary();
                    this.closeAdvancedDialog();
                }, this));
            }

            this.advancedDialog.addCancel("Cancel", $.proxy(function (dialog) {
                this.closeAdvancedDialog();
            }, this));

            var advancedDialogButtonPanel = advancedDialogNode.find(".dialog-button-panel");
            advancedDialogButtonPanel.prepend(AJS.$('<span class="button-spinner"></span>'));

            this.initFontPicker(advancedDialogNode);

            this.advancedDialog.show(advancedDialogNode);
        },

        initFontPicker:function(dialogNode){
            var fontPicker = dialogNode.find(".custom-font-picker");

            fontPicker.auiSelect2({
                allowClear: true,
                delay: 1000,
                dropdownCss:{
                    height:"initial"
                }
            });
        },

        initPagePickers:function(){
            var self = this;
            var pagePickers = this.profileDialogNode.find(".cover-page-picker");

            pagePickers.auiSelect2({
                ajax: {
                    url: this.options.urls.coverPageSearch,
                    data: function(term) {
                        var params = JSON.parse(JSON.stringify(self.options.params));
                        params.term = term;

                        if (self.profile.space)
                        {
                            params.spaceKey = self.profile.space;
                        }

                        AJS.log("cover page search params:"+ JSON.stringify(params));
                        return params;
                    },
                    type: "GET",
                    dataType: 'json',
                    // parse data from the server into form select2 expects
                    results: function results(coverPages) {
                        AJS.log("cover page search result:"+ JSON.stringify(coverPages));

                        var results = [];
                        AJS.$.each(coverPages, function(index, result) {
                            results.push({id:result.id,
                                text:result.title,
                                global:result.global});
                        });
                        return {
                            results: results
                        };
                    }
                },
                allowClear: true,
                delay: 1000,
                dropdownCss:{
                    height:"initial"
                },
                minimumInputLength: 2,
                formatResult: function(data) {
                    if (data.id) {
                        if (data.global) {
                            var lozengeClass = "aui-lozenge-complete";
                            var lozengeText = "Global"
                        }
                        else {
                            var lozengeClass = "aui-lozenge-moved";
                            var lozengeText = "Space"
                        }
                    }
                    else {
                        var lozengeClass = "aui-lozenge-error";
                        var lozengeText = "Missing"
                    }
                    return "<span class='aui-lozenge cex-lozenge " + lozengeClass + "'>" + lozengeText + "</span>" + AJS.escapeHtml(data.text);
                },
                formatSelection:function(data) {
                    return this.formatResult(data);
                },
                initSelection:function(element, callback){
                    var data = JSON.parse(JSON.stringify(self.options.params));
                    data.id = element.val();

                    AJS.$.ajax({
                        url: self.options.urls.coverPageLoad,
                        type: "GET",
                        timeout: 180000, // 3 minutes
                        data: data,
                        cache: false,
                        dataType: "json",
                        success: function(coverPage) {
                            if(coverPage){
                                var selection = {id:coverPage.id,
                                    text:coverPage.title,
                                    global:coverPage.global};
                                callback(selection);
                            }
                            else{
                                callback({text:"Page not found"});
                            }
                        }
                    });
                }
            });
        },

        saveProfile: function() {
            var buttonsContainer = AJS.$(".dialog-button-panel");
            var disabledControls = MIJS.disableControls(buttonsContainer.find("button"));
            var spinner = MIJS.startSpin(buttonsContainer);
            var self = this;
            var profileJson = JSON.stringify(this.profile);
            AJS.log("saving profile: " + profileJson);
            var data = {profileJson : profileJson};
            AJS.$.ajax({
                url: this.options.urls.save,
                type: "POST",
                timeout: 180000, // 3 minutes
                data: data,
                cache: false,
                dataType: "json"
            }).always(function(){
                MIJS.enableControls(disabledControls);
                MIJS.stopSpin(spinner);
            }).done(function(data){
                if (data.status === "invalid-data") {
                    MIJS.renderErrors(self.profileDialogNode, data.errors);
                }
                else {
                    MIJS.resetFormMessages(self.profileDialogNode);
                    AJS.CONTENT_EXPORTER.PROFILE.closeAll(AJS.CONTENT_EXPORTER.PROFILE.profileDialog);
                }
            });
        },

        updateExportParameters: function(){
            var profile = this.profile;
            var exportParameters = AJS.CONTENT_EXPORTER.exportParameters;
            exportParameters.profileId = null;
            exportParameters.customProfileName = profile.name;
            exportParameters.frontCover = profile.formatting.frontCover;
            exportParameters.backCover = profile.formatting.backCover;
            exportParameters.toc = profile.formatting.toc;
            exportParameters.tocTitle = profile.formatting.tocTitle;
            exportParameters.tocLevel = profile.formatting.tocLevel;
            exportParameters.tocMode = profile.formatting.tocMode;
            exportParameters.pageNumbersArea = profile.formatting.pageNumbersArea;
            exportParameters.stylesheetId = profile.formatting.stylesheetId;
            exportParameters.headerFooters = profile.formatting.headerFooters;
            exportParameters.pageSettings = profile.formatting.pageSettings;
            exportParameters.unit = profile.formatting.unit;
            exportParameters.margins = profile.formatting.margins;
            exportParameters.fontResize = profile.formatting.fontResize;
            exportParameters.breakWord = profile.formatting.breakWord;
            exportParameters.separatePage = profile.formatting.separatePage;
            exportParameters.selectedFont = profile.formatting.selectedFont;
            exportParameters.additionalFonts = profile.formatting.additionalFonts;
            exportParameters.headingNumbering = profile.formatting.headingNumbering;
            AJS.log("custom export settings: " + JSON.stringify(exportParameters));
            AJS.CONTENT_EXPORTER.updateProfileSelector();
            AJS.CONTENT_EXPORTER.PROFILE.closeProfileDialog();
        },

        showStylesheetSelectorDialog: function() {
            this.stylesheetSelectorDialog = new AJS.Dialog({
                width: 800,
                height: 500,
                id: "cex-select-stylesheet-dialog"
            });

            this.stylesheetSelectorDialog.addHeader("Select stylesheet");

            this.stylesheetSelectorDialog.addPanel("Stylesheets", this.stylesheetDialogTemplate.clone(), "panel-body");
            if(AJS.Meta.get('access-mode') != "READ_ONLY" || "customize" === this.options.mode){
                this.stylesheetSelectorDialog.addButton("Select", $.proxy(function(dialog) {
                    var selectedRow = AJS.$('tr.stylesheet-row:has(input[name=stylesheet]:checked)');

                    this.profile.formatting.stylesheetId = selectedRow.data("id");

                    this.updateStylesheetSummary();
                    this.closeStylesheetSelectorDialog();
                }, this));
            }

            this.stylesheetSelectorDialog.addCancel("Cancel", $.proxy(function (dialog) {
                this.closeStylesheetSelectorDialog();
            }, this));

            var currentStylesheetId = this.profile.formatting.stylesheetId;
            var currentRow = AJS.$('tr.stylesheet-row[data-id="' + currentStylesheetId + '"');
            currentRow.find("input.radio").prop("checked", true);

            this.stylesheetSelectorDialog.show();
        },

        showHeadersFootersDialog: function(){
            var self = this;

            this.headersFootersDialog = new AJS.Dialog({
                width: 1200,
                height: 500,
                id: "cex-headers-footers-dialog"
            });
            this.headersFootersDialog.addHeader("Headers footers");
            this.headersFootersDialog.addPanel("headersFooters", this.headersFootersDialogTemplate.clone(), "panel-body");

            if(AJS.Meta.get('access-mode') != "READ_ONLY" || "customize" === this.options.mode){
                this.headersFootersDialog.addButton("Apply", $.proxy(function() {
                    this.profile.formatting.headerFooters = [
                        {"headerLeft" : AJS.$("#header-left-content-input").val(),
                            "headerCenter": AJS.$("#header-center-content-input").val(),
                            "headerRight": AJS.$("#header-right-content-input").val(),
                            "footerLeft": AJS.$("#footer-left-content-input").val(),
                            "footerCenter": AJS.$("#footer-center-content-input").val(),
                            "footerRight": AJS.$("#footer-right-content-input").val(),
                            "onCover": AJS.$("#on-cover").prop("checked")
                }];

                    self.updateHeaderFooterSummary();
                    self.closeHeadersFootersDialog();
                }, this));
            }

            this.headersFootersDialog.addCancel("Cancel", $.proxy(function (dialog) {
                self.closeHeadersFootersDialog();
            }, this));

            var headersFootersDialogNode = AJS.$("#"+this.headersFootersDialog.id);
            headersFootersDialogNode.find(".fieldpicker-add-button").click($.proxy(function(e) {
                AJS.log("option clicked");
                var button = AJS.$(e.target);
                var source = headersFootersDialogNode.find("#"+button.data("source-id"));
                var target = headersFootersDialogNode.find("#"+button.data("target-id"));
                var value = source.val();
                if (value && value > ""){
                    target.insertAtCursor(this.headerFooterHints[value]);
                    source.val("");
                }
                e.preventDefault();
            }, this));

            headersFootersDialogNode.find(".fieldpicker-clear-button").click($.proxy(function(e) {
                var trigger = AJS.$(e.target);
                var target = headersFootersDialogNode.find("#"+trigger.data("target-id"));
                target.val("");
                e.preventDefault();
            }, this));

            var headerFooters = this.profile.formatting.headerFooters;
            if(headerFooters.length>0){
                var headerFooter = headerFooters[0];
                AJS.$("#header-left-content-input").val(headerFooter.headerLeft);
                AJS.$("#header-center-content-input").val(headerFooter.headerCenter);
                AJS.$("#header-right-content-input").val(headerFooter.headerRight);
                AJS.$("#footer-left-content-input").val(headerFooter.footerLeft);
                AJS.$("#footer-center-content-input").val(headerFooter.footerCenter);
                AJS.$("#footer-right-content-input").val(headerFooter.footerRight);
                AJS.$("#on-cover").prop("checked", headerFooter.onCover);
            }

            var metaOptions = headersFootersDialogNode.find("#meta-options").remove();
            headersFootersDialogNode.find(".meta-fieldpicker").each(function() {
                var select = AJS.$(this);
                select.html(metaOptions.html());
            });

            this.headersFootersDialog.show();
        },

        showPageSettingsDialog: function(){
            var self = this;

            this.pageSettingsDialog = new AJS.Dialog({
                width: Math.min(this.options.width, 500),
                height: 550,
                id: "cex-page-settings-dialog"
            });

            var pageSettingsDialogNode = AJS.$("#"+this.pageSettingsDialog.id);
            this.pageSettingsDialog.addHeader("Page size and margins");
            this.pageSettingsDialog.addPanel("pageSettings", this.pageSettingsDialogTemplate.clone(), "panel-body");

            function updatePermissions() {
                var pageSizeSelector = AJS.$("#page-size");
                if ("CUSTOM" === pageSizeSelector.val()) {
                    AJS.$(".page-size-predefined").prop("disabled", "disabled");
                    AJS.$(".page-size-custom").removeProp("disabled");
                }
                else {
                    AJS.$(".page-size-custom").prop("disabled", "disabled");
                    AJS.$(".page-size-predefined").removeProp("disabled");

                }
            }

            function updatePageSettingsControls() {
                var formatting = AJS.CONTENT_EXPORTER.PROFILE.profile.formatting;
                var pageSettings = formatting.pageSettings;
                AJS.$("#page-size").val(pageSettings.size);
                AJS.$("#unit").val(formatting.unit);
                AJS.$(".unit").html(AJS.$("#unit :selected").html());
                AJS.$("#orientation").val(pageSettings.orientation);
                AJS.$("#page-width").val(pageSettings.width);
                AJS.$("#page-height").val(pageSettings.height);

                var margins = formatting.margins;
                if(margins && margins.length > 0){
                    var margin = margins[0];
                    AJS.$("#margin-top").val(margin.top);
                    AJS.$("#margin-right").val(margin.right);
                    AJS.$("#margin-bottom").val(margin.bottom);
                    AJS.$("#margin-left").val(margin.left);
                }
            }

            pageSettingsDialogNode.find("#page-size").change($.proxy(function(e) {
                updatePermissions();
            }, this));

            pageSettingsDialogNode.find("#unit").change($.proxy(function(e) {
                AJS.$(".unit").html(AJS.$("#unit option:selected").html());
            }, this));

            pageSettingsDialogNode.find(".number-only").keypress(function(e) {
                if(isNaN(this.value + "" + String.fromCharCode(e.charCode)))
                    return false;
            });

            pageSettingsDialogNode.find(".number-only").on("paste",function(e) {
                var clipboardData = e.originalEvent.clipboardData.getData("text/plain");
                if(isNaN(this.value + "" + clipboardData))
                    return false;
            });

            if(AJS.Meta.get('access-mode') != "READ_ONLY" || "customize" === this.options.mode){
                this.pageSettingsDialog.addButton("Apply", $.proxy(function() {
                    var formatting = this.profile.formatting;
                    formatting.pageSettings ={
                        "size":AJS.$("#page-size").val(),
                        "orientation":AJS.$("#orientation").val(),
                        "width":AJS.$("#page-width").val(),
                        "height":AJS.$("#page-height").val()
                    };

                    formatting.margins = [{
                        "top":AJS.$("#margin-top").val(),
                        "right":AJS.$("#margin-right").val(),
                        "bottom":AJS.$("#margin-bottom").val(),
                        "left":AJS.$("#margin-left").val()
                    }];
                    formatting.unit = AJS.$("#unit").val();

                    self.updatePageSettingsSummary();
                    self.closePageSettingsDialog();
                }, this));
            }

            this.pageSettingsDialog.addCancel("Cancel", function (dialog) {
                self.closePageSettingsDialog();
            });

            updatePageSettingsControls();
            updatePermissions();
            this.pageSettingsDialog.show();
        },

        updatePageSettingsSummary: function() {
            var formatting = this.profile.formatting;
            var pageSettings = formatting.pageSettings;
            var pageSizeSummary = "<p>Size: ";
            var unit = this.pageSettingsDialogTemplate.find("#unit option[value=" + formatting.unit + "]").html();

            if ("CUSTOM" === pageSettings.size) {
                pageSizeSummary += pageSettings.width + " " + unit
                        + " x " + pageSettings.height + " " + unit;
            }
            else {
                var size = this.pageSettingsDialogTemplate.find("#page-size option[value=" + pageSettings.size + "]").html();
                var orientation = this.pageSettingsDialogTemplate.find("#orientation option[value=" + pageSettings.orientation + "]").html();
                pageSizeSummary += size + " " + orientation;
            }
            pageSizeSummary += "</p>";

            var marginSummary = "<p>Margins: ";
            var margins = formatting.margins;
            if (margins && margins.length > 0) {
                var margin = margins[0];
                marginSummary +=
                        "left: " + margin.left + " " + unit + ", " +
                        "right: " + margin.right + " " + unit + ", " +
                        "top: " + margin.top + " " + unit + ", " +
                        "bottom: " + margin.bottom + " " + unit;
            }
            marginSummary += "</p>";

            var summaryContainer = this.profileDialogNode.find("#page-settings-summary");
            summaryContainer.html(pageSizeSummary+marginSummary);
        },

        updateHeaderFooterSummary: function() {
            var headerFooters = this.profile.formatting.headerFooters;
            function showHeaderNotSet() {
                AJS.$("#header-set").hide();
                AJS.$("#header-not-set").show();
            }
            function showFooterNotSet() {
                AJS.$("#footer-set").hide();
                AJS.$("#footer-not-set").show();
            }

            function showHeaderSet() {
                AJS.$("#header-set").show();
                AJS.$("#header-not-set").hide();
            }

            function showFooterSet() {
                AJS.$("#footer-set").show();
                AJS.$("#footer-not-set").hide();
            }

            if(headerFooters.length > 0 ){
                var headerFooter = headerFooters[0];
                this.copyToContentEmptyReplacedWithNbspAndSanitize(headerFooter.headerLeft, "#header-left-summary");
                this.copyToContentEmptyReplacedWithNbspAndSanitize(headerFooter.headerCenter, "#header-center-summary");
                this.copyToContentEmptyReplacedWithNbspAndSanitize(headerFooter.headerRight, "#header-right-summary");
                this.copyToContentEmptyReplacedWithNbspAndSanitize(headerFooter.footerLeft, "#footer-left-summary");
                this.copyToContentEmptyReplacedWithNbspAndSanitize(headerFooter.footerCenter, "#footer-center-summary");
                this.copyToContentEmptyReplacedWithNbspAndSanitize(headerFooter.footerRight, "#footer-right-summary");
                if(headerFooter.headerLeft !== "" ||
                        headerFooter.headerCenter !== "" ||
                        headerFooter.headerRight !== "" ){
                    showHeaderSet();
                }
                else {
                    showHeaderNotSet();
                }
                if(headerFooter.footerLeft !== "" ||
                        headerFooter.footerCenter !== "" ||
                        headerFooter.footerRight !== ""){
                    showFooterSet();
                }
                else {
                    showFooterNotSet();
                }
            }
            else {
                showHeaderNotSet();
                showFooterNotSet();
            }
        },

        copyToContentEmptyReplacedWithNbspAndSanitize: function(source, targetSelector) {
            var target = AJS.$(targetSelector);
            target.html(source===""?"&nbsp;":DOMPurify.sanitize(source));
        },

        updateAdvancedSummary: function() {
            var advancedSummary = "";

            var $selectedFont = this.advancedDialogTemplate.find("#custom-font option[value='" + this.profile.formatting.selectedFont + "']");
            if($selectedFont.length > 0){
                advancedSummary += "<p>Using font: " + $selectedFont.html() + "</p>";
            }
            var additionalFonts = $('#additional-font-selector').select2('data');
            if(additionalFonts.length > 0) {
                var additionalFontsHtml = "<p>Using additional font" + (additionalFonts.length > 1 ? "s: " : ": ");
                for (var i = 0; i < additionalFonts.length; i++) {
                    additionalFontsHtml += AJS.escapeHtml(additionalFonts[i].text) + (i > 0 ? "; " : "");
                }
                additionalFontsHtml += "</p>";
                advancedSummary += additionalFontsHtml;
            }

            if(this.profile.formatting.separatePage){
                advancedSummary += "<p>"+this.advancedDialogTemplate.find("label[for='separate-page']").html() + "</p>";
            }
            if(this.profile.formatting.fontResize){
                advancedSummary += "<p>"+this.advancedDialogTemplate.find("label[for='font-resize']").html() + "</p>";
            }
            if(this.profile.formatting.breakWord){
                advancedSummary += "<p>"+this.advancedDialogTemplate.find("label[for='break-word']").html() + "</p>";
            }
            if(this.profile.formatting.pageNumbersArea.numbersFrom !== "COVER_PAGE" ||
               this.profile.formatting.pageNumbersArea.numbersTo !== "BACK_COVER_PAGE" ) {
                advancedSummary +=
                    "<p>Page numbering generates from " +
                    AJS.CONTENT_EXPORTER.PROFILE.advancedDialogTemplate.find("#page-numbers-area-from option[value=\"" + this.profile.formatting.pageNumbersArea.numbersFrom + "\"]").text() +
                    " to " +
                    AJS.CONTENT_EXPORTER.PROFILE.advancedDialogTemplate.find("#page-numbers-area-to option[value=\"" + this.profile.formatting.pageNumbersArea.numbersTo + "\"]").text() + ".</p>";
            }
            if(!advancedSummary){
                advancedSummary = "<p>No advanced settings set</p>"
            }
            var summaryContainer = this.profileDialogNode.find("#profile-advanced-summary");
            summaryContainer.html(advancedSummary);
        },

        updateStylesheetSummary: function(){
            function showStylesheetSelected(name) {
                var stylesheetName = AJS.$("#stylesheet-name");
                stylesheetName.html(DOMPurify.sanitize(name));
                stylesheetName.show();
                AJS.$("#stylesheet-not-set").hide();
            }

            function showStylesheetNotSelected() {
                AJS.$("#stylesheet-name").hide();
                AJS.$("#stylesheet-not-set").show();
            }

            if (this.profile.formatting.stylesheetId && this.profile.formatting.stylesheetId !== 0) {
                var stylesheetRow = this.stylesheetDialogTemplate.find("tr[data-id="+this.profile.formatting.stylesheetId + "]");
                showStylesheetSelected(stylesheetRow.data("name"));
            }
            else {
                showStylesheetNotSelected();
            }
        },

        updateTableOfContentsSummary: function(){
            var summary = "Depth: "+this.profile.formatting.tocLevel;
            summary += "; Title: "+this.profile.formatting.tocTitle;
            summary += "; Display mode: "+this.profile.formatting.tocMode;

            var summaryContainer = this.profileDialogNode.find("#table-of-contents-summary");
            summaryContainer.html("<p>" + DOMPurify.sanitize(summary) + "</p>");
        },

        closeStylesheetSelectorDialog: function() {
            this.stylesheetSelectorDialog.remove();
            this.stylesheetSelectorDialog = null;
        },

        closeHeadersFootersDialog: function() {
            this.headersFootersDialog.remove();
            this.headersFootersDialog = null;
        },

        closePageSettingsDialog: function() {
            this.pageSettingsDialog.remove();
            this.pageSettingsDialog = null;
        },

        closeAdvancedDialog: function() {
            this.advancedDialog.remove();
            this.advancedDialog = null;
        },

        closeTableOfContentsDialog: function() {
            this.tableOfContentsDialog.remove();
            this.tableOfContentsDialog = null;
        },

        closeProfileDialog: function() {
            this.profileDialog.remove();
            this.profileDialog = null;
        },

        removeAllDialogs: function() {
            if (this.profileDialog) {
                this.profileDialog.remove();
                this.profileDialog = null;
            }
            if(this.stylesheetSelectorDialog){
                this.closeStylesheetSelectorDialog();
            }
            if(this.headersFootersDialog){
                this.closeHeadersFootersDialog();
            }
            if(this.pageSettingsDialog){
                this.closePageSettingsDialog();
            }
        },

        closeAll: function(dialog) {
            if (this.options.onClose) {
                this.options.onClose(dialog);
            }
        }
    }
});
