/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.util;

import hu.metainf.logger.api.Logger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDNamedDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;

public class PDFHelper {
    public static final Logger logger = Logger.getLogger(PDFHelper.class);

    private PDFHelper() {
    }

    public static Map<String, Integer> getAllBookmarkedPageNumber(PDDocument document) throws IOException {
        HashMap<String, Integer> bookmarkedDestinations = new HashMap<String, Integer>();
        PDDocumentOutline documentOutline = document.getDocumentCatalog().getDocumentOutline();
        if (null != documentOutline) {
            PDFHelper.addAllBookmarkedDestinations(bookmarkedDestinations, document, documentOutline.children(), outlineItem -> PDFHelper.getPageNumber(document, outlineItem.getDestination()));
        }
        return bookmarkedDestinations;
    }

    public static int getPageNumber(PDDocument document, PDDestination destination) throws IOException {
        int result = -1;
        PDPageDestination pageDestination = null;
        if (null != destination) {
            if (destination instanceof PDNamedDestination) {
                pageDestination = document.getDocumentCatalog().findNamedDestinationPage((PDNamedDestination)destination);
            } else if (destination instanceof PDPageDestination) {
                pageDestination = (PDPageDestination)destination;
            } else {
                logger.error("Unknown destination class " + destination.getClass());
            }
            if (pageDestination != null) {
                result = pageDestination.retrievePageNumber();
            }
        }
        return result;
    }

    public static Map<String, PDDestination> getAllBookmarkedDestinations(PDDocument document) throws IOException {
        HashMap<String, PDDestination> bookmarkedDestinations = new HashMap<String, PDDestination>();
        PDDocumentOutline documentOutline = document.getDocumentCatalog().getDocumentOutline();
        if (null != documentOutline) {
            PDFHelper.addAllBookmarkedDestinations(bookmarkedDestinations, document, documentOutline.children(), outlineItem -> outlineItem.getDestination());
        }
        return bookmarkedDestinations;
    }

    private static <MAP_VALUE> void addAllBookmarkedDestinations(Map<String, MAP_VALUE> bookmarkedDestinations, PDDocument document, Iterable<PDOutlineItem> outlineItems, FunctionThrowingException<PDOutlineItem, MAP_VALUE, IOException> function) throws IOException {
        if (null != outlineItems) {
            for (PDOutlineItem outlineItem : outlineItems) {
                String bookmarkName = outlineItem.getTitle();
                MAP_VALUE value = function.apply(outlineItem);
                logger.debug("Bookmark " + bookmarkName + " mapped to " + value);
                if (null != bookmarkedDestinations.put(bookmarkName, value) && !bookmarkName.equals("tobedeletedbookmarks")) {
                    logger.error("The bookmark name was not unique " + bookmarkName);
                }
                PDFHelper.addAllBookmarkedDestinations(bookmarkedDestinations, document, outlineItem.children(), function);
            }
        }
    }

    public static void updateInnerDocumentLinks(PDDocument document, String urlPrefix) throws IOException {
        Map<String, PDDestination> bookmarkedDestinations = PDFHelper.getAllBookmarkedDestinations(document);
        PDPageTree pages = document.getPages();
        for (PDPage page : pages) {
            for (PDAnnotation annotation : page.getAnnotations()) {
                PDActionURI uriAction;
                String actionURI;
                PDAnnotationLink annotationLink;
                PDAction action;
                if (!(annotation instanceof PDAnnotationLink) || null == (action = (annotationLink = (PDAnnotationLink)annotation).getAction()) || !(action instanceof PDActionURI) || null == (actionURI = (uriAction = (PDActionURI)action).getURI()) || !actionURI.startsWith(urlPrefix)) continue;
                String path = actionURI.substring((urlPrefix + "#").length());
                if (bookmarkedDestinations.containsKey(path)) {
                    PDActionGoTo gotoAction = new PDActionGoTo();
                    gotoAction.setDestination(bookmarkedDestinations.get(path));
                    annotationLink.setAction((PDAction)gotoAction);
                    logger.debug("Link updated from {} to {}.", new Object[]{actionURI, path});
                    continue;
                }
                logger.error("Bookmarks object misses this bookmark: {}", new Object[]{actionURI});
            }
        }
    }

    public static void updateBookmarks(PDDocument document, UnaryOperator<String> function) {
        PDDocumentOutline documentOutline = document.getDocumentCatalog().getDocumentOutline();
        if (null != documentOutline) {
            PDFHelper.updateBookmarks(documentOutline.children(), function);
        }
    }

    private static void updateBookmarks(Iterable<PDOutlineItem> outlineItems, UnaryOperator<String> function) {
        if (null != outlineItems) {
            for (PDOutlineItem outlineItem : outlineItems) {
                outlineItem.setTitle((String)function.apply(outlineItem.getTitle()));
                PDFHelper.updateBookmarks(outlineItem.children(), function);
            }
        }
    }

    public static void deleteUnneededBookmarks(PDDocument document, Predicate<String> toBeDeleted) throws IOException {
        PDDocumentOutline originalDocOutline = document.getDocumentCatalog().getDocumentOutline();
        PDDocumentOutline newDocOutline = new PDDocumentOutline();
        if (null != originalDocOutline) {
            Iterable outlineItems = originalDocOutline.children();
            for (PDOutlineItem outlineItem : outlineItems) {
                String bookmarkName = outlineItem.getTitle();
                if (toBeDeleted.test(bookmarkName)) continue;
                newDocOutline.addLast(PDFHelper.copyOutlineItem(outlineItem));
                PDFHelper.addChildren((PDOutlineNode)outlineItem, (PDOutlineNode)newDocOutline.getLastChild());
            }
            document.getDocumentCatalog().setDocumentOutline(newDocOutline);
        }
    }

    private static PDOutlineItem copyOutlineItem(PDOutlineItem outlineItem) throws IOException {
        PDOutlineItem result = new PDOutlineItem();
        result.setDestination(outlineItem.getDestination());
        result.setAction(outlineItem.getAction());
        result.setTitle(outlineItem.getTitle());
        result.setTextColor(outlineItem.getTextColor());
        result.setStructureElement(outlineItem.getStructureElement());
        return result;
    }

    private static void addChildren(PDOutlineNode source, PDOutlineNode destination) throws IOException {
        if (null != source) {
            Iterable children = source.children();
            for (PDOutlineItem child : children) {
                destination.addLast(PDFHelper.copyOutlineItem(child));
                PDFHelper.addChildren((PDOutlineNode)child, (PDOutlineNode)destination.getLastChild());
            }
        }
    }

    @FunctionalInterface
    private static interface FunctionThrowingException<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }
}

