/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.standalone.imageloader;

import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.TrustedRequest;
import com.atlassian.sal.api.net.TrustedRequestFactory;
import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.exporter.ImageFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.io.HttpUtil;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.imageloader.TrustedKeyMissingException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

public class InternalHttpImageFetcher
implements ImageFetcher {
    private static final Logger logger = Logger.getLogger(InternalHttpImageFetcher.class);
    private String baseUrl;
    private String contextPath;
    private TrustedRequestFactory requestFactory;

    public InternalHttpImageFetcher(String baseUrl, String contextPath) {
        this.baseUrl = baseUrl;
        this.contextPath = contextPath;
    }

    public InternalHttpImageFetcher(String baseUrl, String contextPath, TrustedRequestFactory requestFactory) {
        this(baseUrl, contextPath);
        this.requestFactory = requestFactory;
    }

    @Override
    public InputStream createImageInputStream(String uri) {
        String response;
        String url;
        String absoluteUrl = this.getAbsoluteUrl(uri);
        try {
            boolean isEncoded;
            String decodedUrl = URLDecoder.decode(absoluteUrl, StandardCharsets.UTF_8);
            boolean bl = isEncoded = !absoluteUrl.equals(decodedUrl);
            url = !isEncoded ? HttpUtil.encodeQueryParams(absoluteUrl) : absoluteUrl;
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            logger.error("Invalid url: {}", new Object[]{absoluteUrl, e});
            throw new IllegalArgumentException(e);
        }
        logger.debug("Internal HTTP image fetcher {} -> {}", new Object[]{uri, absoluteUrl});
        TrustedRequest request = this.requestFactory.createTrustedRequest(Request.MethodType.GET, url);
        try {
            request.addTrustedTokenAuthentication(InternalHttpImageFetcher.getDomainName(url));
            response = request.execute();
        }
        catch (ResponseException | NullPointerException | MalformedURLException e) {
            String message = String.format("Can't create trusted method for %s [Internal HTTP]", uri);
            logger.error(message, e);
            throw new TrustedKeyMissingException(message, e);
        }
        try {
            byte[] b = response.getBytes();
            return new ByteArrayInputStream(b);
        }
        catch (Exception e) {
            logger.warn("Can't create image input stream for {} [Internal HTTP]: {}", new Object[]{uri, e.getMessage()});
            return null;
        }
    }

    String getAbsoluteUrl(String uri) {
        if (uri.startsWith(this.contextPath)) {
            uri = uri.replace(this.contextPath, "");
        }
        return this.baseUrl + uri;
    }

    public static String getDomainName(String url) throws MalformedURLException {
        return new URL(url).getHost();
    }
}

