/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.standalone;

import com.atlassian.confluence.util.velocity.VelocityUtils;
import hu.metainf.plugin.confluence.contentexporter.exporter.ResourceLoader;
import hu.metainf.plugin.confluence.contentexporter.exporter.VelocityTemplate;
import hu.metainf.plugin.confluence.contentexporter.exporter.io.IoUtil;
import java.io.IOException;
import java.io.InputStream;
import org.apache.velocity.app.VelocityEngine;

public class StandaloneResourceLoader
implements ResourceLoader {
    private VelocityEngine velocityEngine;

    @Override
    public String resolveCss(String cssName) throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream is = classLoader.getResourceAsStream("templates/css/" + cssName);
        return IoUtil.read(is);
    }

    @Override
    public VelocityTemplate resolveTemplate(String templateName) throws IOException {
        try {
            return new VelocityTemplate(this.getVelocityEngine().getTemplate("/templates/" + templateName, "UTF-8"));
        }
        catch (Exception e) {
            throw new IOException("Can't resolve template: " + templateName, e);
        }
    }

    @Override
    public InputStream resolveFont(String fontName) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResourceAsStream("fonts/" + fontName);
    }

    @Override
    public InputStream resolveResource(String resourceName) {
        return this.getClass().getClassLoader().getResourceAsStream(resourceName);
    }

    @Override
    public VelocityEngine getVelocityEngine() {
        if (this.velocityEngine == null) {
            try {
                this.velocityEngine = VelocityUtils.getVelocityEngine();
            }
            catch (Exception e) {
                throw new RuntimeException("Can't initialize Velocity Engine!", e);
            }
        }
        return this.velocityEngine;
    }
}

