/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor;

import hu.metainf.plugin.confluence.contentexporter.exporter.ExportContext;
import hu.metainf.plugin.confluence.contentexporter.exporter.ImageFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor.ImageDimension;
import hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor.ImageProcessor;
import hu.metainf.plugin.confluence.contentexporter.util.HtmlCleanerUtil;
import java.io.File;
import org.htmlcleaner.TagNode;

public class DocImageProcessor
extends ImageProcessor {
    private static final int PIXELS_PER_INCH = 72;
    private static final double LETTER_SIZE_WIDTH_INCHES = 8.5;
    private static final int LETTER_SIZE_HEIGHT_INCHES = 11;

    public DocImageProcessor(ImageFetcher imageFetcher) {
        super(imageFetcher);
    }

    @Override
    public void processImage(TagNode imgNode, File imageFile, ExportContext exportContext) {
        int imageWidthAttribute = 0;
        try {
            imageWidthAttribute = Integer.parseInt(imgNode.getAttributeByName("width"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ImageDimension dimension = this.getImageDimension(imageFile);
        if (dimension != null) {
            int desiredWidth;
            int imgWidth = dimension.getWidth();
            int imgHeight = dimension.getHeight();
            int margin = 2;
            int maxWidth = 468;
            int n = desiredWidth = imageWidthAttribute > 0 ? imageWidthAttribute : imgWidth;
            if (desiredWidth > 468) {
                desiredWidth = 468;
            }
            double imageAspectRatio = (double)imgWidth / (double)imgHeight;
            int desiredHeight = (int)((double)desiredWidth / imageAspectRatio);
            HtmlCleanerUtil.addOrReplaceAttribute(imgNode, "width", Integer.toString(desiredWidth));
            HtmlCleanerUtil.addOrReplaceAttribute(imgNode, "height", Integer.toString(desiredHeight));
        }
    }
}

