/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.output;

import hu.metainf.plugin.confluence.contentexporter.exporter.output.HtmlWriter;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluencePage;
import java.util.List;

public class PagesToHtmlListConverter {
    public String toHtmlList(List<ConfluencePage> pages, Long currentPage) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<ul>");
        for (ConfluencePage page : pages) {
            stringBuilder.append(this.toHtmlListItem(page, currentPage));
        }
        stringBuilder.append("</ul>");
        return stringBuilder.toString();
    }

    private String toHtmlListItem(ConfluencePage page, Long selectedPage) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<li>");
        stringBuilder.append("<span>");
        if (selectedPage != null && selectedPage.equals(page.getId())) {
            stringBuilder.append(page.getTitle());
        } else {
            stringBuilder.append("<a href=\"").append(HtmlWriter.getFileName(page.getId())).append("\">").append(page.getTitle()).append("</a>");
        }
        stringBuilder.append("</span>");
        if (!page.getChildren().isEmpty()) {
            stringBuilder.append("<input type=\"checkbox\"");
            if (selectedPage != null && this.isExpanded(page, selectedPage)) {
                stringBuilder.append(" checked");
            }
            stringBuilder.append("/>");
            stringBuilder.append(this.toHtmlList(page.getChildren(), selectedPage));
        }
        stringBuilder.append("</li>");
        return stringBuilder.toString();
    }

    private boolean isExpanded(ConfluencePage currentPage, long selectedPage) {
        boolean isCurrentPage;
        boolean bl = isCurrentPage = currentPage.getId() == selectedPage;
        if (!isCurrentPage) {
            for (int i = 0; !isCurrentPage && i < currentPage.getChildren().size(); ++i) {
                ConfluencePage page = currentPage.getChildren().get(i);
                isCurrentPage = this.isExpanded(page, selectedPage);
            }
        }
        return isCurrentPage;
    }
}

