/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.output;

import hu.metainf.plugin.confluence.contentexporter.ContentExporterException;
import hu.metainf.plugin.confluence.contentexporter.exporter.ContentFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.ExportContext;
import hu.metainf.plugin.confluence.contentexporter.exporter.ResourceLoader;
import hu.metainf.plugin.confluence.contentexporter.exporter.io.BufferedFileWriter;
import hu.metainf.plugin.confluence.contentexporter.exporter.io.IoUtil;
import hu.metainf.plugin.confluence.contentexporter.exporter.output.AbstractOutputWriter;
import hu.metainf.plugin.confluence.contentexporter.exporter.output.HtmlTagBuilder;
import hu.metainf.plugin.confluence.contentexporter.exporter.output.PagesToHtmlListConverter;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluenceContent;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluencePage;
import hu.metainf.plugin.util.StreamHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringEscapeUtils;
import org.htmlcleaner.TagNode;

public class HtmlWriter
extends AbstractOutputWriter {
    private static final int BUFFER = 2048;
    private static final String CONTENT_DIR = "content";
    private final ContentFetcher contentFetcher;
    private final ResourceLoader resourceLoader;
    private final PagesToHtmlListConverter pagesToHtmlListConverter = new PagesToHtmlListConverter();
    private File contentDirectory;
    private String headContent;
    private boolean firstPage = true;
    private final List<ConfluencePage> navigation = new ArrayList<ConfluencePage>();
    private BufferedFileWriter tipueSearchContentWriter;
    private final long rootPageId;
    private final ConfluencePage frontCoverPage;
    private final ConfluencePage backCoverPage;

    public HtmlWriter(ContentFetcher contentFetcher, ResourceLoader resourceLoader, long rootPageId, ConfluencePage frontCoverPage, ConfluencePage backCoverPage, List<? extends ConfluencePage> pages) {
        super(pages);
        this.contentFetcher = contentFetcher;
        this.resourceLoader = resourceLoader;
        this.rootPageId = rootPageId;
        this.frontCoverPage = frontCoverPage;
        this.backCoverPage = backCoverPage;
    }

    @Override
    public void init(ExportContext exportContext) throws IOException {
        super.init(exportContext);
        this.contentDirectory = new File(exportContext.getWorkingDirectory(), CONTENT_DIR);
        if (!this.contentDirectory.exists() && !this.contentDirectory.mkdirs()) {
            throw new IOException("Could not create directory " + this.contentDirectory.getAbsolutePath());
        }
    }

    @Override
    public void addPage(ConfluencePage content, String title, TagNode rootNode) throws ContentExporterException {
        try {
            this.doWrite(content.getId(), intermediateHtmlWriter -> {
                intermediateHtmlWriter.println("<div class='wiki-page'>");
                this.write(intermediateHtmlWriter, title, this.getBody(rootNode));
                intermediateHtmlWriter.println(HtmlTagBuilder.DIV_CLOSE);
            });
            this.indexContent(title, rootNode.getText().toString(), HtmlWriter.getFileName(content.getId()));
            this.indexHtml(content.getId());
        }
        catch (IOException ioe) {
            throw new ContentExporterException(ioe);
        }
    }

    private void indexContent(String title, String body, String fileName) throws IOException {
        this.tipueSearchContentWriter.println("{\"title\": \"" + StringEscapeUtils.escapeJava((String)title) + "\", \"text\": \"" + StringEscapeUtils.escapeJava((String)body) + "\", \"tags\": \"\", \"url\": \"" + fileName + "\"},\n");
    }

    @Override
    public void addFrontCover(ConfluencePage frontCoverPage, String title, TagNode rootNode) throws ContentExporterException {
        try {
            this.doWrite(frontCoverPage.getId(), intermediateHtmlWriter -> {
                intermediateHtmlWriter.println("<div class='cover-page front-cover wiki-page'>");
                this.write(intermediateHtmlWriter, title, this.getBody(rootNode));
                intermediateHtmlWriter.println(HtmlTagBuilder.DIV_CLOSE);
            });
            this.indexContent(title, rootNode.getText().toString(), HtmlWriter.getFileName(frontCoverPage.getId()));
            this.indexHtml(frontCoverPage.getId());
        }
        catch (IOException e) {
            throw new ContentExporterException(e);
        }
    }

    @Override
    public void addPageBreak(String pageClass) {
    }

    @Override
    public void addBackCover(ConfluencePage backCoverPage, String title, TagNode rootNode) throws ContentExporterException {
        try {
            this.doWrite(backCoverPage.getId(), intermediateHtmlWriter -> {
                intermediateHtmlWriter.println("<div class='cover-page back-cover wiki-page'>");
                this.write(intermediateHtmlWriter, title, this.getBody(rootNode));
                intermediateHtmlWriter.println(HtmlTagBuilder.DIV_CLOSE);
            });
            this.indexContent(title, rootNode.getText().toString(), HtmlWriter.getFileName(backCoverPage.getId()));
            this.indexHtml(backCoverPage.getId());
        }
        catch (IOException e) {
            throw new ContentExporterException(e);
        }
    }

    @Override
    public void finish() throws IOException {
        this.tipueSearchContentWriter.println("]};");
        IOUtils.closeQuietly((Writer)this.tipueSearchContentWriter);
        this.copyLibraries();
        this.moveResourcesToContentDirectory();
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public File getIntermediateFile() {
        return this.contentDirectory;
    }

    @Override
    public void addHeadersFooters(String headersFooters) {
    }

    @Override
    public void start(String headContent) throws IOException {
        File tipueSearchContent;
        this.headContent = headContent;
        File tipueSearch = new File(this.contentDirectory, "tipuesearch");
        FileUtils.deleteQuietly((File)tipueSearch);
        if (!tipueSearch.exists()) {
            FileUtils.deleteQuietly((File)tipueSearch);
            if (!tipueSearch.mkdirs()) {
                throw new IOException("Could not create directory " + tipueSearch.getAbsolutePath());
            }
        }
        if (!(tipueSearchContent = new File(tipueSearch, "tipuesearch_content.js")).createNewFile()) {
            throw new IOException("Could not create file " + tipueSearchContent.getAbsolutePath());
        }
        this.tipueSearchContentWriter = new BufferedFileWriter(tipueSearchContent);
        this.tipueSearchContentWriter.println("var tipuesearch = {\"pages\": [\n");
        this.generateNavigation();
    }

    @Override
    public String getPageTitle(String bookmarkId, String pageTitle, int pageHierarchicalLevel) {
        Object classIdentifier = pageHierarchicalLevel != -1 ? "" + pageHierarchicalLevel : "cover";
        return "<h1 class='page-title-lvl-" + (String)classIdentifier + "' id='" + bookmarkId + "'>" + pageTitle + "</h1>";
    }

    @Override
    public File convert(File sourceFile) throws ContentExporterException {
        try {
            File outputFile = this.createOutputFile(sourceFile, "zip");
            this.addFilesToArchive(outputFile);
            return outputFile;
        }
        catch (IOException exception) {
            throw new ContentExporterException(exception);
        }
    }

    private void generateNavigation() {
        List<Long> pageIds = StreamHelper.getAsList(this.pages, ConfluenceContent::getId);
        if (this.frontCoverPage != null) {
            this.navigation.add(this.frontCoverPage);
        }
        this.navigation.addAll(this.contentFetcher.getFilteredPageTree(this.rootPageId, pageIds));
        if (this.backCoverPage != null) {
            this.navigation.add(this.backCoverPage);
        }
    }

    private void copyLibraries() throws IOException {
        this.copyJquery();
        this.copySplitJs();
        this.copyTipuesearch();
        this.searchHtml();
        this.copyFonts();
    }

    private void copySplitJs() throws IOException {
        File splitDir = new File(this.contentDirectory, "split");
        HtmlWriter.copy(this.resourceLoader.resolveResource("templates/html/split/split.min.js"), splitDir, "split.min.js");
    }

    private void copyTipuesearch() throws IOException {
        File tipuesearchDir = new File(this.contentDirectory, "tipuesearch");
        HtmlWriter.copy(this.resourceLoader.resolveResource("templates/html/tipuesearch/tipuesearch.min.js"), tipuesearchDir, "tipuesearch.min.js");
        HtmlWriter.copy(this.resourceLoader.resolveResource("templates/html/tipuesearch/tipuesearch_set.js"), tipuesearchDir, "tipuesearch_set.js");
    }

    private void copyJquery() throws IOException {
        File jqueryDir = new File(this.contentDirectory, "jquery");
        HtmlWriter.copy(this.resourceLoader.resolveResource("templates/html/jquery/jquery-3.2.1.min.js"), jqueryDir, "jquery-3.2.1.min.js");
    }

    private void copyFonts() throws IOException {
        File splitDir = new File(this.contentDirectory, "fonts");
        HtmlWriter.copy(this.resourceLoader.resolveResource("fonts/Atlassian-icons.ttf"), splitDir, "Atlassian-icons.ttf");
    }

    public static void copy(InputStream source, File directory, String fileName) throws IOException {
        if (source == null) {
            throw new FileNotFoundException("Source not found");
        }
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Could not crete directory: " + directory.getAbsolutePath());
        }
        File file = new File(directory, fileName);
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Could not crete file: " + file.getAbsolutePath());
        }
        IoUtil.copy(source, file);
    }

    private void moveResourcesToContentDirectory() throws IOException {
        File workingDirectory = this.exportContext.getWorkingDirectory();
        File[] resources = workingDirectory.listFiles(pathname -> {
            boolean isContentDirectory = pathname.isDirectory() && CONTENT_DIR.equals(pathname.getName());
            boolean isHtmlFile = !pathname.isDirectory() && pathname.getName().endsWith(".html");
            return !isContentDirectory && !isHtmlFile;
        });
        if (resources != null) {
            for (File resource : resources) {
                File targetFile = new File(this.contentDirectory, resource.getName());
                targetFile.delete();
                Files.move(resource.toPath(), targetFile.toPath(), new CopyOption[0]);
            }
        }
    }

    private void indexHtml(long id) throws IOException {
        if (this.firstPage) {
            this.firstPage = false;
            File index = new File(this.contentDirectory, "index.html");
            try (BufferedFileWriter intermediateHtmlWriter = new BufferedFileWriter(index);){
                String page = HtmlWriter.getFileName(id);
                intermediateHtmlWriter.println("<html>\n<head>\n        <meta http-equiv=\"refresh\" content=\"0;URL=" + page + "\">\n</head>\n<body>\n    <p>If you are not being redirected to the start page please click <a href=\"" + page + "\">here</a>.</p>\n</body>\n" + HtmlTagBuilder.HTML_CLOSE);
            }
        }
    }

    private void searchHtml() throws IOException {
        File index = new File(this.contentDirectory, "search.html");
        try (BufferedFileWriter intermediateHtmlWriter = new BufferedFileWriter(index);){
            intermediateHtmlWriter.println("<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\">\n    <title>Search Result</title>\n    <link rel=\"stylesheet\" href=\"combined.css\"/>\n    <script src=\"jquery/jquery-3.2.1.min.js\"></script>\n    <script src=\"tipuesearch/tipuesearch_content.js\"></script>\n    <script src=\"tipuesearch/tipuesearch_set.js\"></script>\n    <script src=\"tipuesearch/tipuesearch.min.js\"></script>\n    <script src=\"split/split.min.js\"></script>\n\n</head>\n");
            intermediateHtmlWriter.println("<div class=\"full-height-container\">");
            this.writeSideBar(intermediateHtmlWriter, null);
            intermediateHtmlWriter.println("<div id=\"content\" class=\"split\">");
            intermediateHtmlWriter.println("<div class='wiki-page'>");
            intermediateHtmlWriter.println("<div class=\"wiki-title\">\n<h1>Search Result</h1>\n" + HtmlTagBuilder.DIV_CLOSE);
            intermediateHtmlWriter.println("<div id=\"tipue_search_content\"></div>");
            intermediateHtmlWriter.println(HtmlTagBuilder.DIV_CLOSE);
            intermediateHtmlWriter.println(HtmlTagBuilder.DIV_CLOSE);
            intermediateHtmlWriter.println(HtmlTagBuilder.DIV_CLOSE);
            intermediateHtmlWriter.println("<script>\n" + this.getSplit() + "    $(document).ready(function() {\n        $('#tipue_search_input').tipuesearch();\n    });\n</script>\n</body>\n" + HtmlTagBuilder.HTML_CLOSE);
            intermediateHtmlWriter.println(HtmlTagBuilder.DIV_CLOSE);
        }
    }

    private void doWrite(long pageId, ContentWriter contentWriter) throws IOException {
        File intermediateHtmlContentFile = new File(this.contentDirectory, HtmlWriter.getFileName(pageId));
        if (!intermediateHtmlContentFile.exists() && !intermediateHtmlContentFile.createNewFile()) {
            throw new IOException("Could not create file " + intermediateHtmlContentFile.getAbsolutePath());
        }
        try (BufferedFileWriter intermediateHtmlWriter = new BufferedFileWriter(intermediateHtmlContentFile);){
            intermediateHtmlWriter.println(this.headContent);
            intermediateHtmlWriter.println("<div class=\"full-height-container\">");
            this.writeSideBar(intermediateHtmlWriter, pageId);
            intermediateHtmlWriter.println("<div id=\"content\" class=\"split\">");
            contentWriter.writeContent(intermediateHtmlWriter);
            intermediateHtmlWriter.println(HtmlTagBuilder.DIV_CLOSE);
            intermediateHtmlWriter.println(HtmlTagBuilder.DIV_CLOSE);
            intermediateHtmlWriter.println("<script>\n" + this.getSplit() + "</script>\n");
            intermediateHtmlWriter.println("</body>");
            intermediateHtmlWriter.println(HtmlTagBuilder.HTML_CLOSE);
        }
    }

    private String getSplit() {
        return "Split(['#sidebar', '#content'], {\n    sizes: [15, 85],\n    minSize: 100\n});\n";
    }

    private void writeSideBar(BufferedFileWriter intermediateHtmlWriter, Long pageId) throws IOException {
        intermediateHtmlWriter.println("<div id=\"sidebar\" class=\"split\">");
        this.writeSearch(intermediateHtmlWriter);
        this.writeNavigation(intermediateHtmlWriter, pageId);
        intermediateHtmlWriter.println(HtmlTagBuilder.DIV_CLOSE);
    }

    private void writeNavigation(BufferedFileWriter intermediateHtmlWriter, Long pageId) throws IOException {
        intermediateHtmlWriter.println("<div class=\"navgroup\" id=\"navigation\">");
        intermediateHtmlWriter.println(this.pagesToHtmlListConverter.toHtmlList(this.navigation, pageId));
        intermediateHtmlWriter.println(HtmlTagBuilder.DIV_CLOSE);
    }

    private void writeSearch(BufferedFileWriter intermediateHtmlWriter) throws IOException {
        intermediateHtmlWriter.println("<div class=\"navgroup\" id=\"search\">");
        intermediateHtmlWriter.println("<form action=\"search.html\" class=\"aui\">\n<input type=\"text\" name=\"q\" id=\"tipue_search_input\" class=\"medium-field text\">\n<input class=\"button submit\" type=\"submit\" value=\"Search\"></form>");
        intermediateHtmlWriter.println(HtmlTagBuilder.DIV_CLOSE);
    }

    public static String getFileName(long contentId) {
        return "page" + contentId + ".html";
    }

    private void addFilesToArchive(File outputFile) throws IOException {
        Collection<File> files = this.getFilesToCompress();
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
             ZipOutputStream zipOutputStream = new ZipOutputStream(bufferedOutputStream);){
            byte[] data = new byte[2048];
            zipOutputStream.setMethod(8);
            this.addFilesToArchive(files, zipOutputStream, data);
        }
    }

    private Collection<File> getFilesToCompress() {
        return FileUtils.listFiles((File)this.contentDirectory, (IOFileFilter)new IOFileFilter(){

            public boolean accept(File file) {
                return true;
            }

            public boolean accept(File file, String s) {
                return true;
            }
        }, (IOFileFilter)new IOFileFilter(){

            public boolean accept(File file) {
                return true;
            }

            public boolean accept(File file, String s) {
                return HtmlWriter.this.toCompress(s);
            }
        });
    }

    private void addFilesToArchive(Collection<File> files, ZipOutputStream zipOutputStream, byte[] data) throws IOException {
        for (File currentFile : files) {
            this.addToArchive(currentFile, zipOutputStream, data);
        }
    }

    private void addToArchive(File file, ZipOutputStream out, byte[] data) throws IOException {
        FileInputStream fi = new FileInputStream(file);
        try (BufferedInputStream origin = new BufferedInputStream(fi, 2048);){
            int count;
            String path = this.contentDirectory.toURI().relativize(file.toURI()).getPath();
            ZipEntry entry = new ZipEntry(path);
            out.putNextEntry(entry);
            while ((count = origin.read(data, 0, 2048)) != -1) {
                out.write(data, 0, count);
            }
        }
    }

    private boolean toCompress(String currentFileName) {
        return !currentFileName.startsWith("fragment");
    }

    private static interface ContentWriter {
        public void writeContent(BufferedFileWriter var1) throws IOException;
    }
}

