/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter;

import hu.metainf.logger.api.Logger;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityTemplate {
    private Template template;
    private Map<String, Object> params = new HashMap<String, Object>();
    private VelocityEngine velocityEngine;
    private String templateString;

    public VelocityTemplate(VelocityEngine velocityEngine, @NotNull String templateString) {
        this.velocityEngine = velocityEngine;
        this.templateString = templateString;
        try {
            Velocity.init();
        }
        catch (Exception e) {
            Logger.getLogger(VelocityTemplate.class).error("Failed to init the velocity engine", (Throwable)e);
        }
    }

    public VelocityTemplate(@NotNull Template template) {
        this.template = template;
    }

    public VelocityTemplate put(String key, Object value) {
        this.params.put(key, value);
        return this;
    }

    public void putAll(Map<String, Object> values) {
        this.params.putAll(values);
    }

    public String merge() throws IOException {
        StringWriter sw = new StringWriter();
        VelocityContext velocityContext = new VelocityContext(this.params);
        if (null != this.template) {
            this.template.merge((Context)velocityContext, (Writer)sw);
        } else {
            this.velocityEngine.evaluate((Context)velocityContext, (Writer)sw, "template", this.templateString);
        }
        return sw.toString();
    }
}

