/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.controllers;

import com.atlassian.confluence.spaces.actions.SpaceAdminAction;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.controllers.ActionUtil;
import hu.metainf.plugin.confluence.contentexporter.dao.ExportProfileRepository;
import hu.metainf.plugin.confluence.contentexporter.dao.StylesheetRepository;
import hu.metainf.plugin.confluence.contentexporter.model.ExportProfile;
import hu.metainf.plugin.confluence.contentexporter.model.Stylesheet;
import hu.metainf.plugin.confluence.contentexporter.service.ExportProfileService;
import java.io.IOException;
import java.util.List;

public class SpaceProfileAction
extends SpaceAdminAction {
    private static final Logger logger = Logger.getLogger(SpaceProfileAction.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private transient ExportProfileService profileService;
    private transient ExportProfileRepository profileRepository;
    private transient StylesheetRepository stylesheetRepository;
    private transient List<ExportProfile> profiles;
    private transient List<Stylesheet> stylesheets;
    private String profileJson;
    private boolean globalCoversSpaceMissing;

    public void setProfileService(ExportProfileService profileService) {
        this.profileService = profileService;
    }

    public void setProfileRepository(ExportProfileRepository profileRepository) {
        this.profileRepository = profileRepository;
    }

    public void setStylesheetRepository(StylesheetRepository stylesheetRepository) {
        this.stylesheetRepository = stylesheetRepository;
    }

    public String list() {
        this.globalCoversSpaceMissing = !this.profileService.isGlobalCoversSpaceExists();
        this.profiles = this.profileRepository.findAllInSpace(this.getSpaceKey());
        return "success";
    }

    public String newSpaceProfile() throws IOException {
        this.stylesheets = this.stylesheetRepository.findAll();
        try {
            this.profileJson = this.objectMapper.writeValueAsString((Object)new ExportProfile(this.getSpaceKey()));
            ActionUtil.sendJsonResponse(this.profileJson);
        }
        catch (JsonProcessingException e) {
            logger.error("error creating new profile", (Throwable)e);
            return "error";
        }
        return "success";
    }

    public List<ExportProfile> getProfiles() {
        return this.profiles;
    }

    public List<Stylesheet> getStylesheets() {
        return this.stylesheets;
    }

    public String getProfileJson() {
        return this.profileJson;
    }

    public void setProfileJson(String profileJson) {
        this.profileJson = profileJson;
    }

    public boolean isGlobalCoversSpaceMissing() {
        return this.globalCoversSpaceMissing;
    }
}

