/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.controllers;

import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.core.ConfluenceSystemProperties;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.actions.PageAware;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.status.SystemErrorInformationLogger;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.osgi.bridge.external.PluginRetrievalService;
import com.atlassian.user.User;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.controllers.ActionUtil;
import hu.metainf.plugin.confluence.contentexporter.controllers.ContentExporterFactory;
import hu.metainf.plugin.confluence.contentexporter.controllers.MessageResolver;
import hu.metainf.plugin.confluence.contentexporter.dao.ConfigurationRepository;
import hu.metainf.plugin.confluence.contentexporter.dao.ExportParametersRepository;
import hu.metainf.plugin.confluence.contentexporter.dao.ExportProfileRepository;
import hu.metainf.plugin.confluence.contentexporter.dao.StylesheetRepository;
import hu.metainf.plugin.confluence.contentexporter.exporter.ContentExporter;
import hu.metainf.plugin.confluence.contentexporter.exporter.OperationResult;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.StandalonePermissionUtil;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluenceContent;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluencePage;
import hu.metainf.plugin.confluence.contentexporter.model.ExportParameters;
import hu.metainf.plugin.confluence.contentexporter.model.ExportProfile;
import hu.metainf.plugin.confluence.contentexporter.model.ExportType;
import hu.metainf.plugin.confluence.contentexporter.model.OutputFormat;
import hu.metainf.plugin.confluence.contentexporter.model.Stylesheet;
import hu.metainf.plugin.confluence.contentexporter.service.ConfluenceContentService;
import hu.metainf.plugin.confluence.contentexporter.service.ExportExecutorService;
import hu.metainf.plugin.confluence.contentexporter.service.ExportFutureTask;
import hu.metainf.plugin.license.LicenseInfo;
import hu.metainf.plugin.license.PluginLicenseManager;
import hu.metainf.plugin.util.AccessModeService;
import hu.metainf.plugin.util.DataCenterHelper;
import hu.metainf.plugin.util.ErrorCollection;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.struts2.ServletActionContext;

public class ExportAction
extends AbstractSpaceAction
implements PageAware {
    private static final String PAGE_LINK = "<a href=\"{0}\" class=\"page-tree-label\">{1}</a>";
    private static final String OPEN_DIALOG = "open_dialog";
    private static final Logger logger = Logger.getLogger(ExportAction.class);
    private AbstractPage page;
    private transient ConfluenceContentService confluenceContentService;
    private transient StylesheetRepository stylesheetRepository;
    private transient ExportProfileRepository profileRepository;
    private transient ExportExecutorService exportExecutorService;
    private transient PluginLicenseManager pluginLicenseManager;
    private transient ConfigurationRepository configurationRepository;
    private transient Renderer renderer;
    private transient ExportParametersRepository exportParametersRepository;
    private transient ContentExporterFactory contentExporterFactory;
    private transient DataCenterHelper dataCenterHelper;
    private transient PluginRetrievalService pluginRetrievalService;
    private final transient AccessModeService compatibleAccessModeService = new AccessModeService();
    private transient ConfluencePage rootPage;
    private transient ExportParameters exportParameters;
    private transient String exportPageSelection;
    private String labels;
    private String hash;
    private boolean isLicensed;
    private String errorMessage;
    private transient List<Stylesheet> stylesheets;
    private String exportParametersJson;
    private transient List<ExportProfile> globalProfiles;
    private transient List<ExportProfile> spaceProfiles;
    private transient ExportProfile noProfile;
    private OutputFormat format;
    private final ObjectMapper om = new ObjectMapper();

    public void setPluginRetrievalService(PluginRetrievalService pluginRetrievalService) {
        this.pluginRetrievalService = pluginRetrievalService;
    }

    public void setConfluenceContentService(ConfluenceContentService confluenceContentService) {
        this.confluenceContentService = confluenceContentService;
    }

    public void setStylesheetRepository(StylesheetRepository stylesheetRepository) {
        this.stylesheetRepository = stylesheetRepository;
    }

    public void setProfileRepository(ExportProfileRepository profileRepository) {
        this.profileRepository = profileRepository;
    }

    public void setExportExecutorService(ExportExecutorService exportExecutorService) {
        this.exportExecutorService = exportExecutorService;
    }

    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public void setConfigurationRepository(ConfigurationRepository configurationRepository) {
        this.configurationRepository = configurationRepository;
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public void setExportParametersRepository(ExportParametersRepository exportParametersRepository) {
        this.exportParametersRepository = exportParametersRepository;
    }

    public void setContentExporterFactory(ContentExporterFactory contentExporterFactory) {
        this.contentExporterFactory = contentExporterFactory;
    }

    public void setDataCenterHelper(DataCenterHelper dataCenterHelper) {
        this.dataCenterHelper = dataCenterHelper;
    }

    public String openDialog() throws Exception {
        LicenseInfo license = this.pluginLicenseManager.getLicenseInfo();
        this.setIsLicensed(license != null && license.isValid());
        try {
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            this.rootPage = null;
            if (this.page != null && StandalonePermissionUtil.hasSpaceExportPermission((User)user, this.page, this.spacePermissionManager, this.configurationRepository)) {
                this.rootPage = this.confluenceContentService.getPageTree((Page)this.page);
            }
            if (this.rootPage == null) {
                this.errorMessage = "Sorry, the page is either removed or Content Exporter has no permission to access it!";
                return "error";
            }
            this.stylesheets = this.stylesheetRepository.findAll();
            this.globalProfiles = this.profileRepository.findGlobals();
            this.spaceProfiles = this.profileRepository.findAllInSpace(this.getSpaceKey());
            this.noProfile = ExportProfile.NO_PROFILE;
            this.exportPageSelection = this.configurationRepository.load().getExportPageSelection();
            this.restoreExportParameters(user);
            if (this.exportParameters == null) {
                this.exportParameters = new ExportParameters(this.page.getId(), this.format);
            } else {
                this.exportParameters.setOutputFormat(this.format);
                if (!this.isStylesheetExists(this.exportParameters.getStylesheetId())) {
                    this.exportParameters.setStylesheetId(0L);
                }
            }
            ObjectMapper om = new ObjectMapper();
            this.exportParametersJson = om.writeValueAsString((Object)this.exportParameters);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return OPEN_DIALOG;
    }

    private boolean isStylesheetExists(long stylesheetId) {
        return this.stylesheetRepository.getById(stylesheetId) != null;
    }

    private void restoreExportParameters(ConfluenceUser user) {
        if (user != null) {
            this.exportParameters = this.exportParametersRepository.loadLastExportParameters(this.page.getId());
        }
    }

    public String export() throws Exception {
        if (StandalonePermissionUtil.hasSpaceExportPermission((User)AuthenticatedUserThreadLocal.get(), this.page, this.spacePermissionManager, this.configurationRepository)) {
            return this.doExport();
        }
        return "none";
    }

    private void setFinalOutputFormat(ExportParameters exportParameters) {
        if (OutputFormat.PDF.equals((Object)exportParameters.getOutputFormat()) && (this.dataCenterHelper.isDataCenter() || !this.configurationRepository.load().isPageBreakOptionEnabled() || exportParameters.getFormatting().isSeparatePage())) {
            exportParameters.setOutputFormat(OutputFormat.PDF_MERGE);
            logger.debug("PDF MERGE output format has been set.");
        }
    }

    private String doExport() throws Exception {
        ObjectNode result;
        block6: {
            LicenseInfo license = this.pluginLicenseManager.getLicenseInfo();
            if (license == null || !license.isValid()) {
                ActionUtil.sendBadRequest("Missing or expired license!");
                return "error";
            }
            ObjectMapper om = new ObjectMapper();
            result = om.createObjectNode();
            try {
                ExportFutureTask future = this.exportExecutorService.getExportFuture(this.hash);
                if (future == null) {
                    this.sendReadyFailedResponse("Job in poll was not found for hash: " + this.hash);
                    return "error";
                }
                ContentExporter contentExporter = future.getContentExporter();
                contentExporter.extract();
                OperationResult operationResult = contentExporter.getStatus();
                if (operationResult.isSuccess()) {
                    this.exportExecutorService.execute(this.hash);
                } else {
                    ActionUtil.setInternalServerError();
                    result.put("message", operationResult.getGlobalError());
                    result.put("details", operationResult.getGobalErrorDetails());
                }
            }
            catch (Exception e) {
                ActionUtil.setInternalServerError();
                result.setAll(this.handleException(e));
                if (!logger.isErrorEnabled()) break block6;
                logger.error(new SystemErrorInformationLogger(UUID.randomUUID(), ServletActionContext.getServletContext(), ServletActionContext.getRequest()).toString(false), (Throwable)e);
            }
        }
        ActionUtil.sendJsonResponse((JsonNode)result);
        return "none";
    }

    public String init() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode result = objectMapper.createObjectNode();
        ExportParameters exportParameters = (ExportParameters)objectMapper.readValue(this.exportParametersJson, ExportParameters.class);
        this.setFinalOutputFormat(exportParameters);
        ExportType exportType = exportParameters.getExportType();
        switch (exportType) {
            case PAGE: {
                exportParameters.getSelectedContentIdList().clear();
                exportParameters.getSelectedContentIdList().add(this.page.getId());
                break;
            }
            case ALL_CHILD: {
                exportParameters.getSelectedContentIdList().clear();
                ConfluencePage rootPage = this.confluenceContentService.getPageTree((Page)this.page);
                this.getChildrenPages(rootPage, exportParameters.getSelectedContentIdList());
            }
        }
        ContentExporter contentExporter = this.contentExporterFactory.createContentExporter(exportParameters, this.renderer);
        this.exportExecutorService.queueExport(contentExporter, AuthenticatedUserThreadLocal.get());
        this.saveExportParameters(exportParameters);
        result.put("hash", contentExporter.getExportId());
        ActionUtil.sendJsonResponse((JsonNode)result);
        return "none";
    }

    private void getChildrenPages(ConfluencePage rootPage, List<Long> selectedContentIdList) {
        selectedContentIdList.add(rootPage.getId());
        for (ConfluencePage child : rootPage.getChildren()) {
            this.getChildrenPages(child, selectedContentIdList);
        }
    }

    public String labelFilter() throws Exception {
        if (StringUtils.isBlank((String)this.labels)) {
            ActionUtil.sendBadRequest("Invalid label filter request");
        }
        List<ConfluenceContent> visitedPages = this.confluenceContentService.getFilteredPageList(this.page, this.labels);
        ObjectMapper om = new ObjectMapper();
        ArrayNode result = om.createArrayNode();
        for (ConfluenceContent content : visitedPages) {
            result.add(content.getId());
        }
        ActionUtil.sendJsonResponse((JsonNode)result);
        return "none";
    }

    public String download() throws Exception {
        logger.debug("Start download for hash: {}", new Object[]{this.hash});
        if (StringUtils.isBlank((String)this.hash)) {
            logger.debug("Empty hash received for file download!");
            ActionUtil.sendBadRequest((JsonNode)this.invalidDownloadRequest("Empty hash received for file download!"));
            return "none";
        }
        ExportFutureTask future = this.exportExecutorService.getExportFuture(this.hash);
        if (future == null) {
            logger.debug("Job not found for hash: {}", new Object[]{this.hash});
            ActionUtil.sendBadRequest((JsonNode)this.invalidDownloadRequest(String.format("Job not found for hash: %s", this.hash)));
            return "none";
        }
        if (!future.isDone()) {
            logger.debug("Job is not ready for hash: {}", new Object[]{this.hash});
            ActionUtil.sendBadRequest((JsonNode)this.invalidDownloadRequest(String.format("Job is not ready for hash: %s", this.hash)));
            return "none";
        }
        try {
            ContentExporter exporter = (ContentExporter)future.get();
            File outputFile = (File)exporter.getStatus().getData();
            if (!outputFile.exists()) {
                logger.debug("Exported file not found: {}", new Object[]{outputFile});
                ActionUtil.sendBadRequest((JsonNode)this.invalidDownloadRequest(String.format("Exported file not found: %s", outputFile.getAbsolutePath())));
                return "none";
            }
            ActionUtil.sendFileResponse(exporter.getOutputFilename(), exporter.getOutputContentType(), outputFile, this.hash);
            this.cleanup(exporter);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            logger.error("Job failed for hash: {}", new Object[]{this.hash, cause});
            ActionUtil.sendInternalServerError((JsonNode)this.handleException(cause));
        }
        catch (Exception e) {
            logger.error("Job failed for hash: {}", new Object[]{this.hash, e});
            ActionUtil.sendInternalServerError((JsonNode)this.handleException(e));
        }
        return "none";
    }

    private void cleanup(ContentExporter exporter) {
        if (!ConfluenceSystemProperties.isDisableCaches()) {
            exporter.cleanup();
        }
    }

    private ObjectNode invalidDownloadRequest(String details) {
        ObjectNode invalidDownloadRequest = this.om.createObjectNode();
        invalidDownloadRequest.put("message", "Invalid download request!");
        invalidDownloadRequest.put("details", details);
        return invalidDownloadRequest;
    }

    public String poll() throws Exception {
        logger.debug("Calling poll for: {}", new Object[]{this.hash});
        if (StringUtils.isBlank((String)this.hash)) {
            this.sendReadyFailedResponse("Empty hash received for poll!");
            return "error";
        }
        ExportFutureTask future = this.exportExecutorService.getExportFuture(this.hash);
        if (future == null) {
            this.sendReadyFailedResponse("Job in poll was not found for hash: " + this.hash);
            return "error";
        }
        ObjectNode result = this.om.createObjectNode();
        boolean done = future.isDone();
        result.put("ready", done);
        if (done) {
            try {
                OperationResult operationResult = future.getResult();
                boolean success = operationResult.isSuccess();
                result.put("success", success);
                if (!success) {
                    ErrorCollection errors = operationResult.getErrors();
                    result.put("exportId", this.hash);
                    MessageResolver messageResolver = new MessageResolver(this.getI18n());
                    result.put("message", messageResolver.resolve(errors.getGlobalErrorMessage(), errors.getGlobalErrorArguments()));
                    result.put("details", messageResolver.resolve(errors.getGlobalErrorDetails(), errors.getGlobalErrorDetailsArguments()));
                }
            }
            catch (Exception e) {
                logger.error("Exception during poll", (Throwable)e);
                result.setAll(this.handleException(e));
            }
        } else {
            result.putPOJO("progress", (Object)future.getContentExporter().getProgress().getData());
        }
        ActionUtil.sendJsonResponse((JsonNode)result);
        return "none";
    }

    private void sendReadyFailedResponse(String message) throws Exception {
        logger.debug(message);
        ObjectNode result = this.om.createObjectNode();
        result.put("ready", true);
        result.put("success", false);
        result.put("message", message);
        ActionUtil.sendJsonResponse((JsonNode)result);
    }

    private ObjectNode handleException(Throwable e) {
        ObjectNode result = this.om.createObjectNode();
        result.put("success", false);
        result.put("message", e.getMessage());
        result.put("details", ExceptionUtils.getStackTrace((Throwable)e));
        return result;
    }

    private void saveExportParameters(ExportParameters exportParameters) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null && exportParameters != null && exportParameters.getRootContentId() != null && !this.compatibleAccessModeService.isReadOnlyAccessModeEnabled()) {
            this.exportParametersRepository.save(exportParameters);
        }
    }

    public AbstractPage getPage() {
        return this.page;
    }

    public void setPage(AbstractPage page) {
        this.page = page;
    }

    public boolean isPageRequired() {
        return true;
    }

    public boolean isLatestVersionRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    public ConfluencePage getRootPage() {
        return this.rootPage;
    }

    public ExportParameters getExportParameters() {
        return this.exportParameters;
    }

    public List<Stylesheet> getStylesheets() {
        return this.stylesheets;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getBaseUrl() {
        return this.settingsManager.getGlobalSettings().getBaseUrl();
    }

    public String getLicensed() {
        return Boolean.toString(this.isLicensed);
    }

    public void setIsLicensed(boolean isLicensed) {
        this.isLicensed = isLicensed;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getPluginKey() {
        return this.pluginRetrievalService.getPlugin().getKey();
    }

    public PluginLicenseManager getPluginLicenseManager() {
        return this.pluginLicenseManager;
    }

    @HtmlSafe
    public String getPageLink(ConfluencePage page) {
        if (page == null) {
            return null;
        }
        return MessageFormat.format(PAGE_LINK, this.getBaseUrl() + "/pages/viewpage.action?pageId=" + page.getId(), page.getTitle());
    }

    public String getExportParametersJson() {
        return this.exportParametersJson;
    }

    public void setExportParametersJson(String exportParametersJson) {
        this.exportParametersJson = exportParametersJson;
    }

    public List<ExportProfile> getGlobalProfiles() {
        return this.globalProfiles;
    }

    public List<ExportProfile> getSpaceProfiles() {
        return this.spaceProfiles;
    }

    public ExportProfile getNoProfile() {
        return this.noProfile;
    }

    public void setFormat(String format) {
        this.format = OutputFormat.getByKey(format);
    }

    public String getExportPageSelection() {
        return this.exportPageSelection;
    }

    public void setExportPageSelection(String exportPageSelection) {
        this.exportPageSelection = exportPageSelection;
    }
}

