AJS.toInit(function () {
    AJS.CONTENT_EXPORTER = AJS.CONTENT_EXPORTER || {};

    AJS.CONTENT_EXPORTER.initError = function(options) {
        this.options = options;
        this.headerAvatarTemplate = AJS.$(".content-exporter-header-avatar").remove();
    };

    AJS.CONTENT_EXPORTER.showError = function(msg, module) {
        var sizeDiv = AJS.$("<div style='position: absolute; visibility: hidden; width: 600px'></div>");
        sizeDiv.html(msg);
        sizeDiv.appendTo("body");
        var h = sizeDiv.height();
        sizeDiv.remove();

        this.errorDialog = new AJS.Dialog({
            width: 600,
            height: h + 160,
            id: "cex-error-dialog",
            closeOnOutsideClick: false,
            keypressListener: $.proxy(function(e) {
                if (e.keyCode == 27) {
                    this.closeError();
                    e.preventDefault();
                }
            }, this)
        });
        this.errorDialog.module = module;
        this.errorDialogNode = AJS.$("#" + this.errorDialog.id);

        this.errorDialog.addHeader("Error", "dialog-warning");
        this.errorDialogNode.find(".dialog-title").prepend(AJS.CONTENT_EXPORTER.headerAvatarTemplate.clone());

        this.errorDialog.addButton("OK", $.proxy(function(dialog) {
            this.closeError();
        }, this));

        this.errorDialog.addPanel("", "<p>" + msg + "</p>", "panel-body");
        this.errorDialogNode.find(".error-message").html(msg);
        this.errorDialogNode.find("#error-details-toggler").click($.proxy(function(e) {
            e.preventDefault();
            AJS.$("#error-details").toggle();
            this.errorDialog.updateHeight();
        }, this));
        this.errorDialog.show();
    };

    AJS.CONTENT_EXPORTER.closeError = function() {
        this.errorDialog.remove();
        AJS.$(".content-exporter-blanket").css({width: 0, height: 0});
        if (this.errorDialog.module) {
            this.errorDialog.module.closeAll(null);
        }
    };

    AJS.CONTENT_EXPORTER.jsonToErrorMessage = function (msg, json) {
        if (json.message) {
            msg += "<br/>Reason: " + json.message;
        }
        if (json.details) {
            msg += "<div style='text-align: right; font-size: small'><a id='error-details-toggler' style='cursor: pointer'>Details</a></div>";
            msg += "<div id='error-details' style='display: none;overflow: scroll'>" + json.details + "</div>";
        }
        return msg;
    };

    AJS.CONTENT_EXPORTER.createErrorMessage = function(msg, jqXHR) {
        if(jqXHR){
            var ct = jqXHR.getResponseHeader("content-type") || "";
            if (jqXHR.responseText > '' && ct.indexOf("application/json") > -1) {
                try {
                    var o = JSON.parse(jqXHR.responseText);
                    if(o){
                        msg = this.jsonToErrorMessage(msg, o);
                    }
                }
                catch (error) {
                }
            }
            else if (jqXHR.responseText > '' && ct.indexOf("text/plain") > -1){
                msg = msg + "<br/>Reason: " + jqXHR.responseText;
            }
            else if(jqXHR.statusText > ''){
                msg = msg + "<br/>Reason: " + jqXHR.statusText;
            }
        }
        return msg;
    };
});