/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.logger;

import hu.metainf.logger.CustomLevel;
import hu.metainf.logger.FormattingTuple;
import hu.metainf.logger.MessageFormatter;
import hu.metainf.logger.api.Logger;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class Log4JLogger
extends Logger {
    private org.apache.log4j.Logger logger;

    public void setLevel(Level level) {
        this.logger.setLevel(level);
    }

    Log4JLogger(String name) {
        this.logger = org.apache.log4j.Logger.getLogger((String)name);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    public void trace(String message) {
        this.logger.log((Priority)CustomLevel.TRACE, (Object)message);
    }

    public void trace(String message, Object ... args) {
        if (this.logger.isEnabledFor((Priority)CustomLevel.TRACE)) {
            FormattingTuple ft = MessageFormatter.arrayFormat(message, args);
            this.logger.log((Priority)CustomLevel.TRACE, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    public void trace(String message, Throwable error) {
        this.logger.log((Priority)CustomLevel.TRACE, (Object)message, error);
    }

    public void debug(String message) {
        this.logger.debug((Object)message);
    }

    public void debug(String message, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(message, args);
            this.logger.debug((Object)ft.getMessage(), ft.getThrowable());
        }
    }

    public void debug(String message, Throwable error) {
        this.logger.debug((Object)message, error);
    }

    public void info(String message) {
        this.logger.info((Object)message);
    }

    public void info(String message, Object ... args) {
        if (this.logger.isInfoEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(message, args);
            this.logger.info((Object)ft.getMessage(), ft.getThrowable());
        }
    }

    public void info(String message, Throwable error) {
        this.logger.info((Object)message, error);
    }

    public void warn(String message) {
        this.logger.warn((Object)message);
    }

    public void warn(String message, Object ... args) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            FormattingTuple ft = MessageFormatter.arrayFormat(message, args);
            this.logger.warn((Object)ft.getMessage(), ft.getThrowable());
        }
    }

    public void warn(String message, Throwable error) {
        this.logger.warn((Object)message, error);
    }

    public void error(String message) {
        this.logger.error((Object)message);
    }

    public void error(String message, Object ... args) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            FormattingTuple ft = MessageFormatter.arrayFormat(message, args);
            this.logger.error((Object)ft.getMessage(), ft.getThrowable());
        }
    }

    public void error(String message, Throwable error) {
        this.logger.error((Object)message, error);
    }
}

