AJS.toInit(function() {
    initDeleteFontButtons();
    initUploadButton();
});
function initUploadButton(){
    if(AJS.Meta.get('render-mode') == "READ_ONLY"){
        AJS.$("#font-upload-submit").disable();
    }

    $( "font-upload" ).submit(function() {
      return AJS.Meta.get('access-mode') != "READ_ONLY";
    });
}
function initDeleteFontButtons() {
    var deleteConfirmationDialogTemplate = AJS.$("#cex-delete-font-confirmation-dialog-template").remove();
    if(AJS.Meta.get('render-mode') == "READ_ONLY"){
        AJS.$(".delete-font").disable();
    }
    AJS.$(".delete-font").click(function(event) {
        if(AJS.Meta.get('access-mode') != "READ_ONLY"){
            event.preventDefault();
            var target = AJS.$(this);
            var spinner = MIJS.startSpin(target.parent());
            var fontId = target.data("font-id");
            var fontName = target.data("font-name");

            var $content = deleteConfirmationDialogTemplate.clone();
            $content.find("#font-name").text(fontName);

            var confirmationDialog = new AJS.Dialog({
                width: 600,
                height: 200,
                id: "cex-confirmation-dialog"
            });
            confirmationDialog.addHeader("Confirmation");
            confirmationDialog.addPanel("", $content);
            confirmationDialog.addButton("OK", function() {
                window.location.href = AJS.contextPath() + "/admin/plugins/contentexporter/fonts/delete.action?id=" + fontId;
            });
            confirmationDialog.addCancel("Cancel", function (dialog) {
                confirmationDialog.remove();
            });

            confirmationDialog.show();
            MIJS.stopSpin(spinner);
        }
    });
}
