/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor;

import hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor.TablePageProcessor;
import hu.metainf.plugin.confluence.contentexporter.util.HtmlCleanerUtil;
import java.util.List;
import org.htmlcleaner.HtmlNode;
import org.htmlcleaner.TagNode;

public class StyleCleanerTablePageProcessor
extends TablePageProcessor {
    private static final String ATT_STYLE = "style";
    private static final String CLASS_EXC_BOLD = "bold";
    private static final String CLASS_EXC_ITALIC = "italic";
    private static final String CLASS_EXC_UNDERLINE = "underline";
    private static final String STYLE_MAX_HEIGHT = "max-height";
    private static final String STYLE_MIN_HEIGHT = "min-height";
    private static final String STYLE_HEIGHT = "height";
    private static final String STYLE_MIN_WIDTH = "min-width";
    private static final String STYLE_WIDTH = "width";
    private static final String STYLE_WORD_WRAP = "word-wrap";
    private static final String TAG_COL = "col";
    private static final String TAG_EM = "em";
    private static final String TAG_STRONG = "strong";
    private static final String TAG_TD = "td";
    private static final String TAG_TR = "tr";
    private static final String TAG_U = "u";
    private static final String VALUE_REGEX = ".*";

    @Override
    protected void processTable(TagNode table) {
        TagNode thead = table.findElementByName("thead", false);
        if (thead != null) {
            thead.removeFromTree();
        }
        List cols = table.getElementListByName(TAG_COL, true);
        for (TagNode col : cols) {
            this.removeStyle(col, STYLE_WIDTH);
        }
        List rows = table.getElementListByName(TAG_TR, true);
        for (TagNode row : rows) {
            this.removeStyle(row, STYLE_MAX_HEIGHT);
            this.removeStyle(row, STYLE_MIN_HEIGHT);
            this.removeStyle(row, STYLE_HEIGHT);
            if (row.hasAttribute("exc-height")) {
                row.removeAttribute("exc-height");
            }
            List cells = row.getElementListByName(TAG_TD, true);
            for (TagNode cell : cells) {
                String oldClass;
                if (this.isExcellentableRowHeader(cell)) {
                    cell.removeFromTree();
                    continue;
                }
                if (cell.hasAttribute("exc-width")) {
                    cell.removeAttribute("exc-width");
                }
                if (cell.hasAttribute("class") && (oldClass = cell.getAttributeByName("class")) != null) {
                    this.classToElement(cell, CLASS_EXC_BOLD, TAG_STRONG);
                    this.classToElement(cell, CLASS_EXC_ITALIC, TAG_EM);
                    this.classToElement(cell, CLASS_EXC_UNDERLINE, TAG_U);
                }
                if (!cell.hasAttribute(ATT_STYLE)) continue;
                this.removeStyle(cell, STYLE_MAX_HEIGHT);
                this.removeStyle(cell, STYLE_MIN_WIDTH);
                this.removeStyle(cell, STYLE_WIDTH);
                this.removeStyle(cell, STYLE_WORD_WRAP);
                for (TagNode node : cell.getAllElementsList(true)) {
                    this.removeStyle(node, STYLE_MAX_HEIGHT);
                }
            }
        }
    }

    private boolean isExcellentableRowHeader(TagNode cell) {
        return cell.hasAttribute("class") && cell.getAttributeByName("class").contains("td-header-data");
    }

    private void classToElement(TagNode cell, String className, String tagName) {
        String oldClass;
        if (cell.hasAttribute("class") && (oldClass = cell.getAttributeByName("class")).contains(className)) {
            HtmlCleanerUtil.addOrReplaceAttribute(cell, "class", oldClass.replaceAll(className, ""));
            TagNode strong = new TagNode(tagName);
            strong.addChildren(cell.getAllChildren());
            cell.removeAllChildren();
            cell.insertChild(0, (HtmlNode)strong);
        }
    }

    private void removeStyle(TagNode node, String styleName) {
        if (node.hasAttribute(ATT_STYLE)) {
            String oldStyle = node.getAttributeByName(ATT_STYLE);
            String styleRegex = this.getStyleRegex(styleName);
            String newStyle = oldStyle.replaceAll(styleRegex, "");
            HtmlCleanerUtil.addOrReplaceAttribute(node, ATT_STYLE, newStyle);
        }
    }

    private String getStyleRegex(String styleName) {
        return styleName + ":\\s*" + VALUE_REGEX + ";?";
    }
}

